/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.swing;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import org.xBaseJ.DBF;
import org.xBaseJ.DBFTypes;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.CurrencyField;
import org.xBaseJ.fields.DateField;
import org.xBaseJ.fields.Field;
import org.xBaseJ.fields.FloatField;
import org.xBaseJ.fields.LogicalField;
import org.xBaseJ.fields.MemoField;
import org.xBaseJ.fields.NumField;
import org.xBaseJ.fields.PictureField;
import org.xBaseJ.xBaseJException;

class dbfCreateModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    int inRow;
    String[] columnName = new String[]{"Name", "Type", "Length", "Dec. Position", "Indexed", "Index Name"};
    int columnCount = 6;
    int rowCount;
    Boolean[] deleted;
    JFrame parent;
    Vector<String> name;
    Vector<String> type;
    Vector<String> length;
    Vector<String> decPos;
    Vector<Boolean> indexInd;
    Vector<String> indexName;

    public dbfCreateModel(DBF dbf) throws xBaseJException {
        this.name = new Vector();
        this.type = new Vector();
        this.length = new Vector();
        this.decPos = new Vector();
        this.indexInd = new Vector();
        this.indexName = new Vector();
        for (int i = 1; i <= dbf.getFieldCount(); ++i) {
            Field f = dbf.getField(i);
            this.name.addElement(f.getName());
            switch (f.getType()) {
                case 'C': {
                    this.type.addElement("Char");
                    break;
                }
                case 'D': {
                    this.type.addElement("Date");
                    break;
                }
                case 'F': {
                    this.type.addElement("Float");
                    break;
                }
                case 'L': {
                    this.type.addElement("Logical");
                    break;
                }
                case 'M': {
                    this.type.addElement("Memo");
                    break;
                }
                case 'N': {
                    this.type.addElement("Num");
                    break;
                }
                case 'P': {
                    this.type.addElement("Picture");
                    break;
                }
                case 'Y': {
                    this.type.addElement("Currency");
                    break;
                }
                default: {
                    this.type.addElement("??????");
                }
            }
            this.length.addElement("" + f.getLength());
            this.decPos.addElement("" + f.getDecimalPositionCount());
            this.indexInd.addElement(false);
            this.indexName.addElement("");
        }
    }

    public dbfCreateModel() {
        this.rowCount = 1;
        this.name = new Vector();
        this.type = new Vector();
        this.length = new Vector();
        this.decPos = new Vector();
        this.indexInd = new Vector();
        this.indexName = new Vector();
        this.name.addElement("");
        this.type.addElement("Char");
        this.length.addElement("1");
        this.decPos.addElement("0");
        this.indexInd.addElement(false);
        this.indexName.addElement("");
    }

    public void insert(int row) {
        this.name.insertElementAt("", row);
        this.type.insertElementAt("Char", row);
        this.length.insertElementAt("1", row);
        this.decPos.insertElementAt("0", row);
        this.indexInd.insertElementAt(false, row);
        this.indexName.insertElementAt("", row);
        this.fireTableRowsInserted(row, row);
    }

    public void delete(int row) {
        this.name.removeElementAt(row);
        this.type.removeElementAt(row);
        this.length.removeElementAt(row);
        this.decPos.removeElementAt(row);
        this.indexInd.removeElementAt(row);
        this.indexName.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void create(File fil, DBFTypes type2) throws xBaseJException, NumberFormatException, IOException {
        Field[] flds = new Field[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            String named = (String)this.getValueAt(i, 0);
            String typed = (String)this.getValueAt(i, 1);
            String lengths = (String)this.getValueAt(i, 2);
            String decpoints = (String)this.getValueAt(i, 3);
            if (typed.compareTo("Date") == 0) {
                DateField df = new DateField(named);
                flds[i] = df;
                continue;
            }
            if (typed.compareTo("Char") == 0) {
                int len = Integer.parseInt(lengths);
                CharField cf = new CharField(named, len);
                flds[i] = cf;
                continue;
            }
            if (typed.compareTo("Currency") == 0) {
                CurrencyField cf = new CurrencyField(named);
                flds[i] = cf;
                continue;
            }
            if (typed.compareTo("Logical") == 0) {
                LogicalField lf = new LogicalField(named);
                flds[i] = lf;
                continue;
            }
            if (typed.compareTo("Memo") == 0) {
                MemoField mf = new MemoField(named);
                flds[i] = mf;
                continue;
            }
            if (typed.compareTo("Num") == 0) {
                int len = Integer.parseInt(lengths);
                int dec = Integer.parseInt(decpoints);
                NumField nf = new NumField(named, len, dec);
                flds[i] = nf;
                continue;
            }
            if (typed.compareTo("Float") == 0) {
                int len = Integer.parseInt(lengths);
                int dec = Integer.parseInt(decpoints);
                FloatField ff = new FloatField(named, len, dec);
                flds[i] = ff;
                continue;
            }
            if (typed.compareTo("Picture") != 0) continue;
            PictureField pf = new PictureField(named);
            flds[i] = pf;
            type2 = DBFTypes.FOXPRO_WITH_MEMO;
        }
        DBF dbf = new DBF(fil.getAbsolutePath(), type2, true);
        dbf.addField(flds);
        dbf.close();
    }

    @Override
    public String getColumnName(int r) {
        return this.columnName[r];
    }

    @Override
    public void setValueAt(Object in, int r, int c) {
        switch (c) {
            case 0: {
                this.name.setElementAt((String)in, r);
                break;
            }
            case 1: {
                this.type.setElementAt((String)in, r);
                String s = (String)in;
                if (s.compareTo("Logical") != 0 && s.compareTo("Memo") != 0 && s.compareTo("Picture") != 0 && s.compareTo("Currency") != 0) break;
                this.setValueAt(false, r, 4);
                break;
            }
            case 2: {
                this.length.setElementAt((String)in, r);
                break;
            }
            case 3: {
                this.decPos.setElementAt((String)in, r);
                break;
            }
            case 4: {
                this.indexInd.setElementAt((Boolean)in, r);
                break;
            }
            case 5: {
                this.indexName.setElementAt((String)in, r);
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int r, int c) {
        switch (c) {
            case 0: {
                return this.name.elementAt(r);
            }
            case 1: {
                return this.type.elementAt(r);
            }
            case 2: {
                return this.length.elementAt(r);
            }
            case 3: {
                return this.decPos.elementAt(r);
            }
            case 4: {
                return this.indexInd.elementAt(r);
            }
            case 5: {
                return this.indexName.elementAt(r);
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public int getRowCount() {
        return this.name.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        String s = (String)this.getValueAt(r, 1);
        switch (c) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                if (s.compareTo("Date") == 0) {
                    return false;
                }
                if (s.compareTo("Memo") == 0) {
                    return false;
                }
                if (s.compareTo("Logical") == 0) {
                    return false;
                }
                if (s.compareTo("Picture") == 0) {
                    return false;
                }
                return s.compareTo("Currency") != 0;
            }
            case 3: {
                if (s.compareTo("Num") == 0) {
                    return true;
                }
                return s.compareTo("Float") == 0;
            }
            case 4: {
                if (s.compareTo("Memo") == 0) {
                    return false;
                }
                if (s.compareTo("Logical") == 0) {
                    return false;
                }
                if (s.compareTo("Picture") == 0) {
                    return false;
                }
                return s.compareTo("Currency") != 0;
            }
            case 5: {
                return this.isCellEditable(r, 4);
            }
        }
        return false;
    }
}

