/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.xBaseJ.DBF;
import org.xBaseJ.indexes.MDX;
import org.xBaseJ.indexes.MDXAnchor;
import org.xBaseJ.indexes.TagDescriptor;
import org.xBaseJ.xBaseJException;

public class MDXFile {
    public File file;
    public RandomAccessFile raFile;
    String name;
    public MDXAnchor anchor;
    public TagDescriptor[] tags;
    public MDX[] MDXes;
    public final short maxTags = (short)47;
    DBF database;

    public MDXFile(String Name4, DBF inDBF, char readonly) throws IOException, xBaseJException {
        try {
            short i;
            this.database = inDBF;
            this.name = Name4.substring(0, Name4.lastIndexOf(46)) + ".mdx";
            this.file = new File(this.name);
            if (!this.file.exists()) {
                throw new xBaseJException("Missing mdx file:" + this.name);
            }
            this.raFile = readonly == 'r' ? new RandomAccessFile(this.file, "r") : new RandomAccessFile(this.file, "rw");
            this.anchor = new MDXAnchor(this.raFile);
            this.anchor.read();
            this.tags = new TagDescriptor[47];
            this.MDXes = new MDX[47];
            for (i = 0; i < this.anchor.getIndexes(); i = (short)(i + 1)) {
                this.tags[i] = new TagDescriptor(this.raFile, (short)(i + 1));
                this.MDXes[i] = new MDX(this, inDBF, i);
            }
            while (i < 47) {
                this.MDXes[i] = null;
                this.tags[i] = null;
                i = (short)(i + 1);
            }
        }
        catch (Throwable t) {
            this.closeFile(this.raFile);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof xBaseJException) {
                throw (xBaseJException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public MDXFile(String Name4, DBF inDBF, boolean destroy) throws IOException {
        try {
            this.database = inDBF;
            this.name = Name4.substring(0, Name4.lastIndexOf(46)) + ".mdx";
            this.file = new File(this.name);
            FileOutputStream tFOS = new FileOutputStream(this.file);
            tFOS.close();
            this.raFile = new RandomAccessFile(this.file, "rw");
            this.anchor = new MDXAnchor(this.raFile);
            this.anchor.set(Name4.substring(0, Name4.lastIndexOf(46)));
            this.anchor.write();
            byte[] wb = new byte[32];
            for (int i = 0; i < 32; ++i) {
                wb[i] = 0;
            }
            this.raFile.seek(512L);
            this.raFile.write(wb);
            this.tags = new TagDescriptor[47];
            this.MDXes = new MDX[47];
        }
        catch (Throwable t) {
            this.closeFile(this.raFile);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void close() throws IOException {
        this.raFile.close();
    }

    public MDX getMDX(String Name4) throws xBaseJException {
        for (int i = 0; i < this.anchor.getIndexes(); ++i) {
            if (!this.tags[i].name.equalsIgnoreCase(Name4)) continue;
            return this.MDXes[i];
        }
        throw new xBaseJException("Unknown tag named " + Name4);
    }

    TagDescriptor getTagDescriptor(int i) {
        return this.tags[i];
    }

    TagDescriptor getTagDescriptor(String Name4) throws xBaseJException {
        for (int i = 0; i < this.anchor.getIndexes(); ++i) {
            if (!this.tags[i].name.equalsIgnoreCase(Name4)) continue;
            return this.tags[i];
        }
        throw new xBaseJException("Unknown tag named " + Name4);
    }

    public MDX createTag(String Name4, String Index2, boolean unique) throws IOException, xBaseJException {
        Name4 = Name4.toUpperCase();
        if (this.anchor.getIndexes() >= 47) {
            throw new xBaseJException("Can't create another tag. Maximum of 47 reached");
        }
        try {
            this.getTagDescriptor(Name4);
            throw new xBaseJException("Tag name already in use");
        }
        catch (xBaseJException e) {
            if (!e.getMessage().startsWith("Unknown tag named")) {
                throw e;
            }
            short i = (short)(this.anchor.getIndexes() + 1);
            this.tags[i - 1] = new TagDescriptor(this, i, Name4);
            MDX newMDX = new MDX(Name4, Index2, this.database, this, this.tags[i - 1], i, unique);
            this.anchor.setIndexes(i);
            this.anchor.write();
            this.MDXes[i - 1] = newMDX;
            if (i > 1) {
                this.tags[i - 2].updateForwardTag(i);
            }
            return newMDX;
        }
    }

    short get_tag_count() {
        return this.anchor.getIndexes();
    }

    void set_blockbytes(short bytes) {
        this.anchor.blockbytes = bytes;
    }

    void drop_tag_count() throws IOException {
        this.anchor.addOneToIndexes();
        this.anchor.write();
    }

    void write_create_header() throws IOException {
        byte[] wb = new byte[32];
        for (int i = 0; i < 32; ++i) {
            wb[i] = 0;
        }
        this.raFile.seek(512L);
        this.raFile.write(wb);
    }

    public void reIndex() throws IOException, xBaseJException {
        short oldIndexCount = this.anchor.getIndexes();
        this.raFile.close();
        this.file.delete();
        this.raFile = new RandomAccessFile(this.file, "rw");
        this.anchor.reset(this.raFile);
        this.anchor.write();
        for (short i = 0; i < oldIndexCount; i = (short)(i + 1)) {
            this.MDXes[i].tagDesc.indheaderpage = this.anchor.get_nextavailable();
            this.MDXes[i].tagDesc.reset(this.raFile);
            this.MDXes[i].tagDesc.write();
            this.MDXes[i].tagHead.reset(this.raFile);
            this.MDXes[i].tagHead.setPos((short)this.anchor.get_nextavailable());
            this.MDXes[i].tagHead.write();
            if (i > 1) {
                this.tags[i - 2].updateForwardTag(i);
            }
            this.anchor.update_nextavailable();
        }
        this.anchor.setIndexes(oldIndexCount);
        this.anchor.write();
    }

    public RandomAccessFile getRAFile() {
        return this.raFile;
    }

    public MDXAnchor getAnchor() {
        return this.anchor;
    }

    private void closeFile(RandomAccessFile f) {
        if (f != null) {
            try {
                f.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

