/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormatSymbols;
import org.xBaseJ.fields.NumField;
import org.xBaseJ.xBaseJException;

public class FloatField
extends NumField {
    private static final long serialVersionUID = 1L;
    private byte decPosition = 0;
    static DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    static char decimalSeparator = dfs.getDecimalSeparator();
    public static final char type = 'F';

    public FloatField() {
    }

    public FloatField(String iName, int iLength, int DecPoint, ByteBuffer inBuffer) throws xBaseJException {
        super(iName, iLength, DecPoint, inBuffer);
        this.decPosition = (byte)DecPoint;
    }

    public FloatField(String iName, int iLength, int DecPoint) throws xBaseJException, IOException {
        super(iName, iLength, DecPoint);
        this.decPosition = (byte)DecPoint;
    }

    @Override
    public char getType() {
        return 'F';
    }

    @Override
    public void put(String inValue) throws xBaseJException {
        int i;
        boolean signOn = false;
        if (inValue.trim().length() == 0) {
            super.put("");
            return;
        }
        for (i = 0; i < inValue.length(); ++i) {
            if (inValue.charAt(i) == '-') {
                signOn = true;
            }
            if (Character.isDigit(inValue.charAt(i)) || inValue.charAt(i) == decimalSeparator) break;
        }
        if (i == inValue.length()) {
            super.put(" ");
            return;
        }
        int start = i;
        while (i < inValue.length() && (Character.isDigit(inValue.charAt(i)) || inValue.charAt(i) == decimalSeparator)) {
            ++i;
        }
        String workstring = inValue.substring(start, i);
        char[] charray = new char[this.Length];
        Double inDouble = new Double(workstring);
        double duble = inDouble;
        for (i = 0; i < this.decPosition; ++i) {
            duble *= 10.0;
        }
        inDouble = new Double(duble + 0.01);
        long longv = inDouble.longValue();
        if (longv < 0L) {
            longv *= -1L;
            signOn = true;
        }
        int realdp = this.Length - this.decPosition;
        String numstring = new String("0123456789");
        for (i = this.Length; i > 0; --i) {
            if (realdp == i && this.decPosition > 0) {
                charray[i - 1] = 46;
                continue;
            }
            long longleft = longv % 10L;
            int whatsleft = (int)longleft;
            if (whatsleft < 0) {
                whatsleft *= -1;
            }
            charray[i - 1] = numstring.charAt(whatsleft);
            longv /= 10L;
        }
        if (signOn) {
            charray[0] = 45;
        }
        for (i = 0; i < charray.length - 1 && charray[i] == '0'; ++i) {
            charray[i] = 32;
        }
        super.put(new String(charray).replace(decimalSeparator, '.'));
    }

    @Override
    public void put(long inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    @Override
    public void put(int inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    @Override
    public void put(float inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    @Override
    public void put(double inValue) throws xBaseJException {
        double d = inValue;
        double d10 = Math.pow(10.0, this.Length - this.decPosition);
        d %= d10;
        d10 = Math.pow(0.1, this.decPosition + 1);
        if (d > 0.0) {
            d += d10;
        }
        if (d < 0.0) {
            d -= d10;
        }
        this.put(String.valueOf(d));
    }
}

