/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.xBaseJ.DBF;
import org.xBaseJ.DBFTypes;
import org.xBaseJ.DBTFile;
import org.xBaseJ.Util;
import org.xBaseJ.xBaseJException;

public class DBT_iv
extends DBTFile {
    static int LAST_IND = 589823;
    int blocks = 0;

    public DBT_iv(DBF iDBF, boolean readOnly) throws IOException, xBaseJException {
        super(iDBF, readOnly, DBFTypes.DBASEIV_WITH_MEMO);
        this.nextBlock = Util.x86(this.file.readInt());
        this.file.skipBytes(16);
        this.memoBlockSize = Util.x86(this.file.readInt());
    }

    public DBT_iv(DBF iDBF, String name, boolean destroy) throws IOException, xBaseJException {
        super(iDBF, name, destroy, DBFTypes.DBASEIV_WITH_MEMO);
        this.nextBlock = 1;
        this.file.writeInt(Util.x86(this.nextBlock));
        for (int i = 0; i < 16; ++i) {
            this.file.writeByte(0);
        }
        this.memoBlockSize = 512;
        this.file.writeInt(Util.x86(this.memoBlockSize));
    }

    @Override
    public void setNextBlock() throws IOException {
    }

    @Override
    public byte[] readBytes(byte[] input) throws IOException, xBaseJException {
        for (int i = 0; i < 10; ++i) {
            if (input[i] != 0) continue;
            input[i] = 32;
        }
        String sPos = new String(input, 0, 10).trim();
        if (sPos.length() == 0) {
            return null;
        }
        long lPos = Long.parseLong(sPos.trim());
        if (lPos == 0L) {
            return null;
        }
        if (lPos * (long)this.memoBlockSize >= this.file.length()) {
            return null;
        }
        this.file.seek(lPos * (long)this.memoBlockSize);
        int orisize = 0;
        int lastind = Util.x86(this.file.readInt());
        if (lastind != LAST_IND) {
            throw new xBaseJException("Unexpected encounter in read text file");
        }
        int size = Util.x86(this.file.readInt());
        orisize = size - 8;
        byte[] work_buffer = new byte[orisize + 1];
        this.file.read(work_buffer, 0, orisize);
        work_buffer[orisize] = 0;
        return work_buffer;
    }

    @Override
    public byte[] write(String value, int originalSize, boolean write, byte[] originalPos) throws IOException, xBaseJException {
        byte[] buffer;
        int bytes_blocks_used;
        int startPos;
        int nextavail = 0;
        int lastused = 0;
        boolean eof = false;
        boolean madebigger = false;
        if (value.length() == 0) {
            byte[] breturn = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
            return breturn;
        }
        madebigger = originalSize == 0 && value.length() > 0 ? true : value.length() / this.memoBlockSize + 1 > originalSize / this.memoBlockSize + 1;
        if (madebigger || write) {
            startPos = this.nextBlock;
            this.nextBlock += (value.length() + 2) / this.memoBlockSize + 1;
            lastused = 0;
        } else {
            String sPos = new String(originalPos, 0, 10);
            lastused = startPos = Integer.parseInt(sPos.trim());
        }
        int length = value.length();
        int pos = (length += 8) / this.memoBlockSize + 1;
        int next_stop = 0;
        int last_stop = 0;
        while (true) {
            long longnextstop;
            try {
                longnextstop = next_stop;
                this.file.seek(longnextstop * (long)this.memoBlockSize);
                nextavail = Util.x86(this.file.readInt());
            }
            catch (EOFException ioe) {
                eof = true;
                break;
            }
            if (nextavail == LAST_IND) {
                throw new xBaseJException("Error while writing to memo file, unexpected encounter");
            }
            bytes_blocks_used = Util.x86(this.file.readInt());
            if (pos <= bytes_blocks_used) {
                longnextstop = next_stop;
                this.file.seek(longnextstop * (long)this.memoBlockSize);
                break;
            }
            last_stop = next_stop;
            next_stop = nextavail;
        }
        this.file.writeInt(Util.x86(LAST_IND));
        this.file.writeInt(Util.x86(length));
        length -= 8;
        try {
            buffer = value.getBytes(DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            buffer = value.getBytes();
        }
        this.file.write(buffer, 0, length);
        if (eof || lastused == 0) {
            nextavail += pos;
        }
        if (eof) {
            long longnextavail = nextavail;
            this.file.seek(longnextavail * (long)this.memoBlockSize - 1L);
            this.file.write(0);
        }
        if (lastused == 0) {
            long longlaststop = last_stop;
            this.file.seek(longlaststop * (long)this.memoBlockSize);
            this.file.writeInt(Util.x86(nextavail));
        } else {
            long longlastused = lastused;
            this.file.seek(longlastused * (long)this.memoBlockSize);
            this.file.writeInt(Util.x86(nextavail));
            bytes_blocks_used = Util.x86(this.file.readInt());
            this.file.seek(lastused * this.memoBlockSize + 4);
            bytes_blocks_used /= this.memoBlockSize;
            this.file.writeInt(Util.x86(++bytes_blocks_used));
            long longlaststop = last_stop;
            this.file.seek(longlaststop * (long)this.memoBlockSize);
            this.file.writeInt(Util.x86(lastused));
        }
        String returnString = new String(Long.toString(next_stop));
        byte[] ten = new byte[10];
        for (pos = 0; pos < 10 - returnString.length(); ++pos) {
            ten[pos] = 48;
        }
        byte[] b = returnString.getBytes();
        int x = 0;
        while (x < b.length) {
            ten[pos] = b[x];
            ++x;
            ++pos;
        }
        return ten;
    }
}

