/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xsd;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.sax.SaxUtils;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SimpleXsdSchema
implements XsdSchema,
InitializingBean {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final QName SCHEMA_NAME = QNameUtils.createQName("http://www.w3.org/2001/XMLSchema", "schema", "xsd");
    private Resource xsdResource;
    private Element schemaElement;

    public SimpleXsdSchema() {
    }

    public SimpleXsdSchema(Resource xsdResource) {
        Assert.notNull(xsdResource, "xsdResource must not be null");
        this.xsdResource = xsdResource;
    }

    public void setXsd(Resource xsdResource) {
        this.xsdResource = xsdResource;
    }

    public String getTargetNamespace() {
        return this.schemaElement.getAttribute("targetNamespace");
    }

    public Source getSource() {
        return new DOMSource(this.schemaElement);
    }

    public XmlValidator createValidator() throws IOException {
        return XmlValidatorFactory.createValidator(this.xsdResource, SCHEMA_NAMESPACE);
    }

    public void afterPropertiesSet() throws ParserConfigurationException, IOException, SAXException {
        Assert.notNull(this.xsdResource, "'xsd' is required");
        Assert.isTrue(this.xsdResource.exists(), "xsd '" + this.xsdResource + "' does not exit");
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.loadSchema(documentBuilder);
    }

    private void loadSchema(DocumentBuilder documentBuilder) throws SAXException, IOException {
        Document schemaDocument = documentBuilder.parse(SaxUtils.createInputSource(this.xsdResource));
        this.schemaElement = schemaDocument.getDocumentElement();
        Assert.isTrue(SCHEMA_NAME.getLocalPart().equals(this.schemaElement.getLocalName()), this.xsdResource + " has invalid root element : [" + this.schemaElement.getLocalName() + "] instead of [schema]");
        Assert.isTrue(SCHEMA_NAME.getNamespaceURI().equals(this.schemaElement.getNamespaceURI()), this.xsdResource + " has invalid root element: [" + this.schemaElement.getNamespaceURI() + "] instead of [" + SCHEMA_NAME.getNamespaceURI() + "]");
        Assert.hasText(this.getTargetNamespace(), this.xsdResource + " has no targetNamespace");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SimpleXsdSchema");
        builder.append('{');
        builder.append(this.getTargetNamespace());
        builder.append('}');
        return builder.toString();
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
    }
}

