/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11;

import java.util.Properties;
import javax.xml.transform.Source;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import org.springframework.ws.wsdl.wsdl11.ProviderBasedWsdl4jDefinition;
import org.springframework.ws.wsdl.wsdl11.Wsdl11Definition;
import org.springframework.ws.wsdl.wsdl11.provider.InliningXsdSchemaTypesProvider;
import org.springframework.ws.wsdl.wsdl11.provider.SoapProvider;
import org.springframework.ws.wsdl.wsdl11.provider.SuffixBasedMessagesProvider;
import org.springframework.ws.wsdl.wsdl11.provider.SuffixBasedPortTypesProvider;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.XsdSchemaCollection;

public class DefaultWsdl11Definition
implements Wsdl11Definition,
InitializingBean {
    private final InliningXsdSchemaTypesProvider typesProvider = new InliningXsdSchemaTypesProvider();
    private final SuffixBasedMessagesProvider messagesProvider = new SuffixBasedMessagesProvider();
    private final SuffixBasedPortTypesProvider portTypesProvider = new SuffixBasedPortTypesProvider();
    private final SoapProvider soapProvider = new SoapProvider();
    private final ProviderBasedWsdl4jDefinition delegate = new ProviderBasedWsdl4jDefinition();
    private String serviceName;

    public DefaultWsdl11Definition() {
        this.delegate.setTypesProvider(this.typesProvider);
        this.delegate.setMessagesProvider(this.messagesProvider);
        this.delegate.setPortTypesProvider(this.portTypesProvider);
        this.delegate.setBindingsProvider(this.soapProvider);
        this.delegate.setServicesProvider(this.soapProvider);
    }

    public void setTargetNamespace(String targetNamespace) {
        this.delegate.setTargetNamespace(targetNamespace);
    }

    public void setSchema(XsdSchema schema) {
        this.typesProvider.setSchema(schema);
    }

    public void setSchemaCollection(XsdSchemaCollection schemaCollection) {
        this.typesProvider.setSchemaCollection(schemaCollection);
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypesProvider.setPortTypeName(portTypeName);
    }

    public void setRequestSuffix(String requestSuffix) {
        this.portTypesProvider.setRequestSuffix(requestSuffix);
        this.messagesProvider.setRequestSuffix(requestSuffix);
    }

    public void setResponseSuffix(String responseSuffix) {
        this.portTypesProvider.setResponseSuffix(responseSuffix);
        this.messagesProvider.setResponseSuffix(responseSuffix);
    }

    public void setFaultSuffix(String faultSuffix) {
        this.portTypesProvider.setFaultSuffix(faultSuffix);
        this.messagesProvider.setFaultSuffix(faultSuffix);
    }

    public void setCreateSoap11Binding(boolean createSoap11Binding) {
        this.soapProvider.setCreateSoap11Binding(createSoap11Binding);
    }

    public void setCreateSoap12Binding(boolean createSoap12Binding) {
        this.soapProvider.setCreateSoap12Binding(createSoap12Binding);
    }

    public void setSoapActions(Properties soapActions) {
        this.soapProvider.setSoapActions(soapActions);
    }

    public void setTransportUri(String transportUri) {
        this.soapProvider.setTransportUri(transportUri);
    }

    public void setLocationUri(String locationUri) {
        this.soapProvider.setLocationUri(locationUri);
    }

    public void setServiceName(String serviceName) {
        this.soapProvider.setServiceName(serviceName);
        this.serviceName = serviceName;
    }

    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasText(this.delegate.getTargetNamespace()) && this.typesProvider.getSchemaCollection() != null && this.typesProvider.getSchemaCollection().getXsdSchemas().length > 0) {
            XsdSchema schema = this.typesProvider.getSchemaCollection().getXsdSchemas()[0];
            this.setTargetNamespace(schema.getTargetNamespace());
        }
        if (!StringUtils.hasText(this.serviceName) && StringUtils.hasText(this.portTypesProvider.getPortTypeName())) {
            this.soapProvider.setServiceName(this.portTypesProvider.getPortTypeName() + "Service");
        }
        this.delegate.afterPropertiesSet();
    }

    public Source getSource() {
        return this.delegate.getSource();
    }
}

