/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportInputStream
extends InputStream {
    private InputStream inputStream;

    protected TransportInputStream() {
    }

    private InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.createInputStream();
            Assert.notNull(this.inputStream, "inputStream must not be null");
        }
        return this.inputStream;
    }

    @Override
    public void close() throws IOException {
        this.getInputStream().close();
    }

    @Override
    public int available() throws IOException {
        return this.getInputStream().available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.getInputStream().mark(readlimit);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean markSupported() {
        try {
            return this.getInputStream().markSupported();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getInputStream().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getInputStream().read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getInputStream().reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getInputStream().skip(n);
    }

    @Override
    public int read() throws IOException {
        return this.getInputStream().read();
    }

    protected abstract InputStream createInputStream() throws IOException;

    public abstract Iterator<String> getHeaderNames() throws IOException;

    public abstract Iterator<String> getHeaders(String var1) throws IOException;
}

