/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.mapping;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.EndpointMapping;
import org.springframework.ws.soap.server.SoapEndpointInvocationChain;
import org.springframework.ws.soap.server.SoapEndpointMapping;

public class DelegatingSoapEndpointMapping
implements InitializingBean,
SoapEndpointMapping {
    private EndpointMapping delegate;
    private String[] actorsOrRoles;
    private boolean isUltimateReceiver = true;

    public void setDelegate(EndpointMapping delegate) {
        this.delegate = delegate;
    }

    public final void setActorOrRole(String actorOrRole) {
        Assert.notNull(actorOrRole, "actorOrRole must not be null");
        this.actorsOrRoles = new String[]{actorOrRole};
    }

    public final void setActorsOrRoles(String[] actorsOrRoles) {
        Assert.notEmpty(actorsOrRoles, "actorsOrRoles must not be empty");
        this.actorsOrRoles = actorsOrRoles;
    }

    public final void setUltimateReceiver(boolean ultimateReceiver) {
        this.isUltimateReceiver = ultimateReceiver;
    }

    public EndpointInvocationChain getEndpoint(MessageContext messageContext) throws Exception {
        EndpointInvocationChain delegateChain = this.delegate.getEndpoint(messageContext);
        if (delegateChain != null) {
            return new SoapEndpointInvocationChain(delegateChain.getEndpoint(), delegateChain.getInterceptors(), this.actorsOrRoles, this.isUltimateReceiver);
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegate, "delegate is required");
    }
}

