/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj.support;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.saaj.SaajSoapMessageException;
import org.springframework.xml.namespace.QNameUtils;
import org.w3c.dom.Element;

public abstract class SaajUtils {
    private static final String WEBLOGIC_9_SAAJ_EXCEPTION_MESSAGE = "This class does not support SAAJ 1.1";
    private static final Log logger = LogFactory.getLog(SaajUtils.class);
    public static final int SAAJ_11 = 0;
    public static final int SAAJ_12 = 1;
    public static final int SAAJ_13 = 2;
    private static final String SAAJ_13_CLASS_NAME = "javax.xml.soap.SAAJMetaFactory";
    private static final Map<String, Integer> saajVersions = Collections.synchronizedMap(new HashMap());
    private static int saajVersion = 1;

    private static boolean isSaaj13() {
        try {
            ClassUtils.forName(SAAJ_13_CLASS_NAME);
            MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
        catch (SOAPException ex) {
            return false;
        }
    }

    private static boolean isSaaj12() {
        if (Element.class.isAssignableFrom(SOAPElement.class)) {
            try {
                MessageFactory messageFactory = MessageFactory.newInstance();
                SOAPMessage message = messageFactory.createMessage();
                try {
                    message.getSOAPBody();
                    return true;
                }
                catch (UnsupportedOperationException ex) {
                    return false;
                }
            }
            catch (SOAPException e) {
                return false;
            }
        }
        return false;
    }

    public static int getSaajVersion() {
        return saajVersion;
    }

    public static int getSaajVersion(SOAPMessage soapMessage) {
        SOAPEnvelope soapEnvelope;
        Assert.notNull(soapMessage, "'soapMessage' must not be null");
        try {
            soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        }
        catch (SOAPException ex) {
            throw new SaajSoapMessageException("Could not access envelope: " + ex.getMessage(), ex);
        }
        return SaajUtils.getSaajVersion((SOAPElement)soapEnvelope);
    }

    public static int getSaajVersion(SOAPElement soapElement) {
        Assert.notNull(soapElement, "'soapElement' must not be null");
        String soapElementClassName = soapElement.getClass().getName();
        Integer saajVersion = saajVersions.get(soapElementClassName);
        if (saajVersion == null) {
            saajVersion = SaajUtils.isSaaj12(soapElement) ? (SaajUtils.isSaaj13(soapElement) ? Integer.valueOf(2) : Integer.valueOf(1)) : Integer.valueOf(0);
            saajVersions.put(soapElementClassName, saajVersion);
            if (logger.isTraceEnabled()) {
                logger.trace("SOAPElement [" + soapElement.getClass().getName() + "] implements " + SaajUtils.getSaajVersionString(saajVersion));
            }
        }
        return saajVersion;
    }

    private static boolean isSaaj13(SOAPElement soapElement) {
        try {
            Method m = soapElement.getClass().getMethod("getElementQName", new Class[0]);
            if (Modifier.isAbstract(m.getModifiers())) {
                logger.warn("Detected SAAJ API version 1.3, while implementation provides version 1.2. Please replace the SAAJ API jar with a version that corresponds to your runtime implementation (which might be provided by your app server).");
                return false;
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean isSaaj12(SOAPElement soapElement) {
        try {
            Method m = soapElement.getClass().getMethod("getPrefix", new Class[0]);
            if (Modifier.isAbstract(m.getModifiers())) {
                logger.warn("Detected SAAJ API version 1.2, while implementation provides version 1.1. Please replace the SAAJ API jar with a version that corresponds to your runtime implementation (which might be provided by your app server).");
                return false;
            }
            soapElement.getPrefix();
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (UnsupportedOperationException ex) {
            if (WEBLOGIC_9_SAAJ_EXCEPTION_MESSAGE.equals(ex.getMessage())) {
                return false;
            }
            throw ex;
        }
    }

    public static String getSaajVersionString() {
        return SaajUtils.getSaajVersionString(saajVersion);
    }

    private static String getSaajVersionString(int saajVersion) {
        if (saajVersion >= 2) {
            return "SAAJ 1.3";
        }
        if (saajVersion == 1) {
            return "SAAJ 1.2";
        }
        if (saajVersion == 0) {
            return "SAAJ 1.1";
        }
        return "";
    }

    public static Name toName(QName qName, SOAPElement resolveElement) throws SOAPException {
        String qNamePrefix = QNameUtils.getPrefix(qName);
        SOAPEnvelope envelope = SaajUtils.getEnvelope(resolveElement);
        if (StringUtils.hasLength(qName.getNamespaceURI()) && StringUtils.hasLength(qNamePrefix)) {
            return envelope.createName(qName.getLocalPart(), qNamePrefix, qName.getNamespaceURI());
        }
        if (StringUtils.hasLength(qName.getNamespaceURI())) {
            Iterator prefixes = SaajUtils.getSaajVersion(resolveElement) == 0 ? resolveElement.getNamespacePrefixes() : resolveElement.getVisibleNamespacePrefixes();
            while (prefixes.hasNext()) {
                String prefix = (String)prefixes.next();
                if (!qName.getNamespaceURI().equals(resolveElement.getNamespaceURI(prefix))) continue;
                return envelope.createName(qName.getLocalPart(), prefix, qName.getNamespaceURI());
            }
            return envelope.createName(qName.getLocalPart(), "", qName.getNamespaceURI());
        }
        return envelope.createName(qName.getLocalPart());
    }

    public static QName toQName(Name name) {
        if (StringUtils.hasLength(name.getURI()) && StringUtils.hasLength(name.getPrefix())) {
            return QNameUtils.createQName(name.getURI(), name.getLocalName(), name.getPrefix());
        }
        if (StringUtils.hasLength(name.getURI())) {
            return new QName(name.getURI(), name.getLocalName());
        }
        return new QName(name.getLocalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPMessage loadMessage(Resource resource, MessageFactory messageFactory) throws SOAPException, IOException {
        InputStream is = resource.getInputStream();
        try {
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", "text/xml");
            mimeHeaders.addHeader("Content-Length", Long.toString(resource.getFile().length()));
            SOAPMessage sOAPMessage = messageFactory.createMessage(mimeHeaders, is);
            return sOAPMessage;
        }
        finally {
            is.close();
        }
    }

    public static SOAPEnvelope getEnvelope(SOAPElement element) {
        Assert.notNull(element, "Element should not be null");
        do {
            if (!(element instanceof SOAPEnvelope)) continue;
            return (SOAPEnvelope)element;
        } while ((element = element.getParentElement()) != null);
        return null;
    }

    static {
        saajVersion = SaajUtils.isSaaj13() ? 2 : (SaajUtils.isSaaj12() ? 1 : 0);
    }
}

