/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapElement;
import org.springframework.ws.soap.saaj.Saaj11Implementation;
import org.springframework.ws.soap.saaj.Saaj12Implementation;
import org.springframework.ws.soap.saaj.Saaj13Implementation;
import org.springframework.ws.soap.saaj.SaajImplementation;
import org.springframework.ws.soap.saaj.SaajSoapElementException;
import org.springframework.ws.soap.saaj.support.SaajUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SaajSoapElement
implements SoapElement {
    private final SOAPElement element;
    private SaajImplementation implementation;

    SaajSoapElement(SOAPElement element) {
        Assert.notNull(element, "element must not be null");
        this.element = element;
    }

    @Override
    public Source getSource() {
        return this.getImplementation().getSource(this.element);
    }

    @Override
    public QName getName() {
        return this.getImplementation().getName(this.element);
    }

    @Override
    public void addAttribute(QName name, String value) {
        try {
            this.getImplementation().addAttribute(this.element, name, value);
        }
        catch (SOAPException ex) {
            throw new SaajSoapElementException(ex);
        }
    }

    @Override
    public void removeAttribute(QName name) {
        try {
            this.getImplementation().removeAttribute(this.element, name);
        }
        catch (SOAPException ex) {
            throw new SaajSoapElementException(ex);
        }
    }

    @Override
    public String getAttributeValue(QName name) {
        try {
            return this.getImplementation().getAttributeValue(this.element, name);
        }
        catch (SOAPException ex) {
            throw new SaajSoapElementException(ex);
        }
    }

    @Override
    public Iterator<QName> getAllAttributes() {
        return this.getImplementation().getAllAttributes(this.element);
    }

    @Override
    public void addNamespaceDeclaration(String prefix, String namespaceUri) {
        try {
            this.getImplementation().addNamespaceDeclaration(this.element, prefix, namespaceUri);
        }
        catch (SOAPException ex) {
            throw new SaajSoapElementException(ex);
        }
    }

    protected final SOAPElement getSaajElement() {
        return this.element;
    }

    protected final SaajImplementation getImplementation() {
        if (this.implementation == null) {
            if (SaajUtils.getSaajVersion(this.element) == 2) {
                this.implementation = Saaj13Implementation.getInstance();
            } else if (SaajUtils.getSaajVersion(this.element) == 1) {
                this.implementation = Saaj12Implementation.getInstance();
            } else if (SaajUtils.getSaajVersion(this.element) == 0) {
                this.implementation = Saaj11Implementation.getInstance();
            } else {
                throw new IllegalStateException("Could not find SAAJ on the classpath");
            }
        }
        return this.implementation;
    }
}

