/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPProcessingException;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.axiom.AxiomSoap12Fault;
import org.springframework.ws.soap.axiom.AxiomSoapBody;
import org.springframework.ws.soap.axiom.AxiomSoapFaultException;
import org.springframework.ws.soap.axiom.support.AxiomUtils;
import org.springframework.ws.soap.soap12.Soap12Body;
import org.springframework.ws.soap.soap12.Soap12Fault;

class AxiomSoap12Body
extends AxiomSoapBody
implements Soap12Body {
    AxiomSoap12Body(SOAPBody axiomBody, SOAPFactory axiomFactory, boolean payloadCaching) {
        super(axiomBody, axiomFactory, payloadCaching);
    }

    public SoapFault addMustUnderstandFault(String reason, Locale locale) {
        Assert.notNull(locale, "No locale given");
        SOAPFault fault = this.addStandardFault("MustUnderstand", reason, locale);
        return new AxiomSoap12Fault(fault, this.getAxiomFactory());
    }

    public SoapFault addClientOrSenderFault(String reason, Locale locale) {
        Assert.notNull(locale, "No locale given");
        SOAPFault fault = this.addStandardFault("Sender", reason, locale);
        return new AxiomSoap12Fault(fault, this.getAxiomFactory());
    }

    public SoapFault addServerOrReceiverFault(String reason, Locale locale) {
        Assert.notNull(locale, "No locale given");
        SOAPFault fault = this.addStandardFault("Receiver", reason, locale);
        return new AxiomSoap12Fault(fault, this.getAxiomFactory());
    }

    public SoapFault addVersionMismatchFault(String reason, Locale locale) {
        Assert.notNull(locale, "No locale given");
        SOAPFault fault = this.addStandardFault("VersionMismatch", reason, locale);
        return new AxiomSoap12Fault(fault, this.getAxiomFactory());
    }

    public Soap12Fault addDataEncodingUnknownFault(QName[] subcodes, String reason, Locale locale) {
        Assert.notNull(locale, "No locale given");
        SOAPFault fault = this.addStandardFault("DataEncodingUnknown", reason, locale);
        return new AxiomSoap12Fault(fault, this.getAxiomFactory());
    }

    private SOAPFault addStandardFault(String localName, String faultStringOrReason, Locale locale) {
        Assert.notNull(faultStringOrReason, "No faultStringOrReason given");
        try {
            AxiomUtils.removeContents((OMContainer)this.getAxiomBody());
            SOAPFault fault = this.getAxiomFactory().createSOAPFault(this.getAxiomBody());
            SOAPFaultCode code = this.getAxiomFactory().createSOAPFaultCode(fault);
            SOAPFaultValue value = this.getAxiomFactory().createSOAPFaultValue(code);
            value.setText(fault.getNamespace().getPrefix() + ":" + localName);
            SOAPFaultReason reason = this.getAxiomFactory().createSOAPFaultReason(fault);
            SOAPFaultText text = this.getAxiomFactory().createSOAPFaultText(reason);
            if (locale != null) {
                text.setLang(AxiomUtils.toLanguage(locale));
            }
            text.setText(faultStringOrReason);
            return fault;
        }
        catch (SOAPProcessingException ex) {
            throw new AxiomSoapFaultException(ex);
        }
    }

    public SoapFault getFault() {
        SOAPFault axiomFault = this.getAxiomBody().getFault();
        return axiomFault != null ? new AxiomSoap12Fault(axiomFault, this.getAxiomFactory()) : null;
    }
}

