/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.axiom.AxiomSoapHeader;
import org.springframework.ws.soap.soap11.Soap11Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AxiomSoap11Header
extends AxiomSoapHeader
implements Soap11Header {
    AxiomSoap11Header(SOAPHeader axiomHeader, SOAPFactory axiomFactory) {
        super(axiomHeader, axiomFactory);
    }

    @Override
    public Iterator<SoapHeaderElement> examineHeaderElementsToProcess(final String[] actors) {
        RolePlayer rolePlayer = null;
        if (!ObjectUtils.isEmpty(actors)) {
            rolePlayer = new RolePlayer(){

                public List<?> getRoles() {
                    return Arrays.asList(actors);
                }

                public boolean isUltimateDestination() {
                    return false;
                }
            };
        }
        Iterator result = this.getAxiomHeader().getHeadersToProcess(rolePlayer);
        return new AxiomSoapHeader.AxiomSoapHeaderElementIterator(this, result);
    }
}

