/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.version;

import java.net.URI;
import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.version.AbstractAddressingVersion;
import org.springframework.xml.namespace.QNameUtils;

public class Addressing10
extends AbstractAddressingVersion {
    private static final String NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";

    public void addAddressingHeaders(SoapMessage message, MessageAddressingProperties map) {
        Assert.notNull(map.getAction(), "'Action' is required");
        super.addAddressingHeaders(message, map);
    }

    public boolean hasRequiredProperties(MessageAddressingProperties map) {
        if (map.getAction() == null) {
            return false;
        }
        if (map.getReplyTo() != null || map.getFaultTo() != null) {
            return map.getMessageId() != null;
        }
        return true;
    }

    protected String getNamespaceUri() {
        return NAMESPACE_URI;
    }

    protected QName getReferencePropertiesName() {
        return null;
    }

    protected URI getDefaultTo() {
        return this.getAnonymous();
    }

    protected EndpointReference getDefaultReplyTo(EndpointReference from) {
        return new EndpointReference(this.getAnonymous());
    }

    protected final URI getAnonymous() {
        return URI.create("http://www.w3.org/2005/08/addressing/anonymous");
    }

    protected final URI getNone() {
        return URI.create("http://www.w3.org/2005/08/addressing/none");
    }

    protected final QName getMessageAddressingHeaderRequiredFaultSubcode() {
        return QNameUtils.createQName(NAMESPACE_URI, "MessageAddressingHeaderRequired", this.getNamespacePrefix());
    }

    protected final String getMessageAddressingHeaderRequiredFaultReason() {
        return "A required header representing a Message Addressing Property is not present";
    }

    protected QName getInvalidAddressingHeaderFaultSubcode() {
        return QNameUtils.createQName(NAMESPACE_URI, "InvalidAddressingHeader", this.getNamespacePrefix());
    }

    protected String getInvalidAddressingHeaderFaultReason() {
        return "A header representing a Message Addressing Property is not valid and the message cannot be processed";
    }

    public String toString() {
        return "WS-Addressing 1.0";
    }
}

