/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.mapping.AbstractAnnotationMethodEndpointMapping;
import org.springframework.ws.server.endpoint.support.PayloadRootUtils;

public class PayloadRootAnnotationMethodEndpointMapping
extends AbstractAnnotationMethodEndpointMapping {
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();

    protected String getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        QName qName = PayloadRootUtils.getPayloadRootQName(messageContext.getRequest().getPayloadSource(), transformerFactory);
        return qName != null ? qName.toString() : null;
    }

    protected String getLookupKeyForMethod(Method method) {
        PayloadRoot annotation = method.getAnnotation(PayloadRoot.class);
        if (annotation != null) {
            QName qname = StringUtils.hasLength(annotation.localPart()) && StringUtils.hasLength(annotation.namespace()) ? new QName(annotation.namespace(), annotation.localPart()) : new QName(annotation.localPart());
            return qname.toString();
        }
        return null;
    }
}

