/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodEndpoint {
    private final Object bean;
    private final Method method;
    private final BeanFactory beanFactory;

    public MethodEndpoint(Object bean, Method method) {
        Assert.notNull(bean, "bean must not be null");
        Assert.notNull(method, "method must not be null");
        this.bean = bean;
        this.method = method;
        this.beanFactory = null;
    }

    public MethodEndpoint(Object bean, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Assert.notNull(bean, "bean must not be null");
        Assert.notNull(methodName, "method must not be null");
        this.bean = bean;
        this.method = bean.getClass().getMethod(methodName, parameterTypes);
        this.beanFactory = null;
    }

    public MethodEndpoint(String beanName, BeanFactory beanFactory, Method method) {
        Assert.hasText(beanName, "'beanName' must not be null");
        Assert.notNull(beanFactory, "'beanFactory' must not be null");
        Assert.notNull(method, "'method' must not be null");
        Assert.isTrue(beanFactory.containsBean(beanName), "Bean factory [" + beanFactory + "] does not contain bean " + "with name [" + beanName + "]");
        this.bean = beanName;
        this.beanFactory = beanFactory;
        this.method = method;
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object invoke(Object[] args) throws Exception {
        Object endpoint = this.bean;
        if (endpoint instanceof String) {
            String endpointName = (String)endpoint;
            endpoint = this.beanFactory.getBean(endpointName);
        }
        try {
            return this.method.invoke(endpoint, args);
        }
        catch (InvocationTargetException ex) {
            this.handleInvocationTargetException(ex);
            throw new IllegalStateException("Unexpected exception thrown by method - " + ex.getTargetException().getClass().getName() + ": " + ex.getTargetException().getMessage());
        }
    }

    private void handleInvocationTargetException(InvocationTargetException ex) throws Exception {
        if (ex.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)ex.getTargetException();
        }
        if (ex.getTargetException() instanceof Error) {
            throw (Error)ex.getTargetException();
        }
        if (ex.getTargetException() instanceof Exception) {
            throw (Exception)ex.getTargetException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof MethodEndpoint) {
            MethodEndpoint other = (MethodEndpoint)o;
            return this.bean.equals(other.bean) && this.method.equals(other.method);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.bean.hashCode() + this.method.hashCode();
    }

    public String toString() {
        if (JdkVersion.getMajorJavaVersion() <= 1) {
            return this.method.toString();
        }
        return GenericToStringProvider.toString(this.method);
    }

    private static class GenericToStringProvider {
        private GenericToStringProvider() {
        }

        public static String toString(Method method) {
            return method.toGenericString();
        }
    }
}

