/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class MarshallingEndpointsBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String GENERIC_MARSHALLING_METHOD_ENDPOINT_ADAPTER_CLASS_NAME = "org.springframework.ws.server.endpoint.adapter.GenericMarshallingMethodEndpointAdapter";
    private static final boolean genericAdapterPresent = ClassUtils.isPresent("org.springframework.ws.server.endpoint.adapter.GenericMarshallingMethodEndpointAdapter");
    private static final String MARSHALLING_METHOD_ENDPOINT_ADAPTER_CLASS_NAME = "org.springframework.ws.server.endpoint.adapter.MarshallingMethodEndpointAdapter";

    MarshallingEndpointsBeanDefinitionParser() {
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected String getBeanClassName(Element element) {
        if (JdkVersion.isAtLeastJava15() && genericAdapterPresent) {
            return GENERIC_MARSHALLING_METHOD_ENDPOINT_ADAPTER_CLASS_NAME;
        }
        return MARSHALLING_METHOD_ENDPOINT_ADAPTER_CLASS_NAME;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
        String unmarshallerName;
        String marshallerName = element.getAttribute("marshaller");
        if (StringUtils.hasText(marshallerName)) {
            beanDefinitionBuilder.addPropertyReference("marshaller", marshallerName);
        }
        if (StringUtils.hasText(unmarshallerName = element.getAttribute("unmarshaller"))) {
            beanDefinitionBuilder.addPropertyReference("unmarshaller", unmarshallerName);
        }
    }
}

