/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.w3c.dom.Element;

class InterceptorsBeanDefinitionParser
implements BeanDefinitionParser {
    InterceptorsBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource(element));
        parserContext.pushContainingComponent(compDefinition);
        List<Element> interceptors = DomUtils.getChildElementsByTagName(element, new String[]{"bean", "interceptor"});
        for (Element interceptor : interceptors) {
            BeanDefinitionHolder interceptorDef;
            String[] pathPatterns;
            RootBeanDefinition mappedInterceptorDef = new RootBeanDefinition(MappedInterceptor.class);
            mappedInterceptorDef.setSource(parserContext.extractSource(interceptor));
            mappedInterceptorDef.setRole(2);
            if ("interceptor".equals(interceptor.getLocalName())) {
                List<Element> paths = DomUtils.getChildElementsByTagName(interceptor, "mapping");
                pathPatterns = new String[paths.size()];
                int i = 0;
                while (i < paths.size()) {
                    pathPatterns[i] = paths.get(i).getAttribute("path");
                    ++i;
                }
                Element interceptorBean = DomUtils.getChildElementByTagName(interceptor, "bean");
                interceptorDef = parserContext.getDelegate().parseBeanDefinitionElement(interceptorBean);
                interceptorDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(interceptorBean, interceptorDef);
            } else {
                pathPatterns = null;
                interceptorDef = parserContext.getDelegate().parseBeanDefinitionElement(interceptor);
                interceptorDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(interceptor, interceptorDef);
            }
            mappedInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, pathPatterns);
            mappedInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, interceptorDef);
            String mappedInterceptorName = parserContext.getReaderContext().registerWithGeneratedName(mappedInterceptorDef);
            parserContext.registerComponent(new BeanComponentDefinition(mappedInterceptorDef, mappedInterceptorName));
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }
}

