/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class ShallowEtagHeaderFilter
extends OncePerRequestFilter {
    private static String HEADER_ETAG = "ETag";
    private static String HEADER_IF_NONE_MATCH = "If-None-Match";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ShallowEtagResponseWrapper responseWrapper = new ShallowEtagResponseWrapper(response);
        filterChain.doFilter(request, responseWrapper);
        byte[] body = responseWrapper.toByteArray();
        String responseETag = this.generateETagHeaderValue(body);
        response.setHeader(HEADER_ETAG, responseETag);
        String requestETag = request.getHeader(HEADER_IF_NONE_MATCH);
        if (responseETag.equals(requestETag)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("ETag [" + responseETag + "] equal to If-None-Match, sending 304");
            }
            response.setStatus(304);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("ETag [" + responseETag + "] not equal to If-None-Match [" + requestETag + "], sending normal response");
            }
            response.setContentLength(body.length);
            FileCopyUtils.copy(body, (OutputStream)response.getOutputStream());
        }
    }

    protected String generateETagHeaderValue(byte[] bytes) {
        StringBuilder builder = new StringBuilder("\"0");
        DigestUtils.appendMd5DigestAsHex(bytes, builder);
        builder.append('\"');
        return builder.toString();
    }

    private static class ShallowEtagResponseWrapper
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream content = new ByteArrayOutputStream();
        private final ServletOutputStream outputStream = new ResponseServletOutputStream();
        private PrintWriter writer;

        private ShallowEtagResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() {
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                String characterEncoding = this.getCharacterEncoding();
                this.writer = characterEncoding != null ? new ResponsePrintWriter(characterEncoding) : new ResponsePrintWriter("ISO-8859-1");
            }
            return this.writer;
        }

        public void resetBuffer() {
            this.content.reset();
        }

        public void reset() {
            super.reset();
            this.resetBuffer();
        }

        private byte[] toByteArray() {
            return this.content.toByteArray();
        }

        private class ResponsePrintWriter
        extends PrintWriter {
            private ResponsePrintWriter(String characterEncoding) throws UnsupportedEncodingException {
                super(new OutputStreamWriter((OutputStream)ShallowEtagResponseWrapper.this.content, characterEncoding));
            }

            public void write(char[] buf, int off, int len) {
                super.write(buf, off, len);
                super.flush();
            }

            public void write(String s, int off, int len) {
                super.write(s, off, len);
                super.flush();
            }

            public void write(int c) {
                super.write(c);
                super.flush();
            }
        }

        private class ResponseServletOutputStream
        extends ServletOutputStream {
            private ResponseServletOutputStream() {
            }

            public void write(int b) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b, off, len);
            }
        }
    }
}

