/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionTestUtils {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final Log logger = LogFactory.getLog(ReflectionTestUtils.class);

    public static void setField(Object target, String name, Object value) {
        ReflectionTestUtils.setField(target, name, value, null);
    }

    public static void setField(Object target, String name, Object value, Class<?> type) {
        Assert.notNull(target, "Target object must not be null");
        Field field = ReflectionUtils.findField(target.getClass(), name, type);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Setting field [" + name + "] on target [" + target + "]");
        }
        ReflectionUtils.makeAccessible(field);
        ReflectionUtils.setField(field, target, value);
    }

    public static Object getField(Object target, String name) {
        Assert.notNull(target, "Target object must not be null");
        Field field = ReflectionUtils.findField(target.getClass(), name);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Getting field [" + name + "] from target [" + target + "]");
        }
        ReflectionUtils.makeAccessible(field);
        return ReflectionUtils.getField(field, target);
    }

    public static void invokeSetterMethod(Object target, String name, Object value) {
        ReflectionTestUtils.invokeSetterMethod(target, name, value, null);
    }

    public static void invokeSetterMethod(Object target, String name, Object value, Class<?> type) {
        Method method;
        Class[] classArray;
        Assert.notNull(target, "Target object must not be null");
        Assert.notNull(name, "Method name must not be empty");
        if (type != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        } else {
            classArray = null;
        }
        Class[] paramTypes = classArray;
        String setterMethodName = name;
        if (!name.startsWith(SETTER_PREFIX)) {
            setterMethodName = SETTER_PREFIX + StringUtils.capitalize(name);
        }
        if ((method = ReflectionUtils.findMethod(target.getClass(), setterMethodName, paramTypes)) == null && !setterMethodName.equals(name)) {
            setterMethodName = name;
            method = ReflectionUtils.findMethod(target.getClass(), setterMethodName, paramTypes);
        }
        if (method == null) {
            throw new IllegalArgumentException("Could not find setter method [" + setterMethodName + "] on target [" + target + "] with parameter type [" + type + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking setter method [" + setterMethodName + "] on target [" + target + "]");
        }
        ReflectionUtils.makeAccessible(method);
        ReflectionUtils.invokeMethod(method, target, value);
    }

    public static Object invokeGetterMethod(Object target, String name) {
        Method method;
        Assert.notNull(target, "Target object must not be null");
        Assert.notNull(name, "Method name must not be empty");
        String getterMethodName = name;
        if (!name.startsWith(GETTER_PREFIX)) {
            getterMethodName = GETTER_PREFIX + StringUtils.capitalize(name);
        }
        if ((method = ReflectionUtils.findMethod(target.getClass(), getterMethodName)) == null && !getterMethodName.equals(name)) {
            getterMethodName = name;
            method = ReflectionUtils.findMethod(target.getClass(), getterMethodName);
        }
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + getterMethodName + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking getter method [" + getterMethodName + "] on target [" + target + "]");
        }
        ReflectionUtils.makeAccessible(method);
        return ReflectionUtils.invokeMethod(method, target);
    }
}

