/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.annotation;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.annotation.ProfileValueSource;
import org.springframework.test.annotation.ProfileValueSourceConfiguration;
import org.springframework.test.annotation.SystemProfileValueSource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProfileValueUtils {
    private static final Log logger = LogFactory.getLog(ProfileValueUtils.class);

    public static ProfileValueSource retrieveProfileValueSource(Class<?> testClass) {
        ProfileValueSource profileValueSource;
        Assert.notNull(testClass, "testClass must not be null");
        Class<ProfileValueSourceConfiguration> annotationType = ProfileValueSourceConfiguration.class;
        ProfileValueSourceConfiguration config = testClass.getAnnotation(annotationType);
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved @ProfileValueSourceConfiguration [" + config + "] for test class [" + testClass.getName() + "]");
        }
        Class profileValueSourceType = config != null ? config.value() : (Class)AnnotationUtils.getDefaultValue(annotationType);
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved ProfileValueSource type [" + profileValueSourceType + "] for class [" + testClass.getName() + "]");
        }
        if (SystemProfileValueSource.class.equals((Object)profileValueSourceType)) {
            profileValueSource = SystemProfileValueSource.getInstance();
        } else {
            try {
                profileValueSource = (ProfileValueSource)profileValueSourceType.newInstance();
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Could not instantiate a ProfileValueSource of type [" + profileValueSourceType + "] for class [" + testClass.getName() + "]: using default.", e);
                }
                profileValueSource = SystemProfileValueSource.getInstance();
            }
        }
        return profileValueSource;
    }

    public static boolean isTestEnabledInThisEnvironment(Class<?> testClass) {
        IfProfileValue ifProfileValue = testClass.getAnnotation(IfProfileValue.class);
        return ProfileValueUtils.isTestEnabledInThisEnvironment(ProfileValueUtils.retrieveProfileValueSource(testClass), ifProfileValue);
    }

    public static boolean isTestEnabledInThisEnvironment(Method testMethod, Class<?> testClass) {
        return ProfileValueUtils.isTestEnabledInThisEnvironment(ProfileValueUtils.retrieveProfileValueSource(testClass), testMethod, testClass);
    }

    public static boolean isTestEnabledInThisEnvironment(ProfileValueSource profileValueSource, Method testMethod, Class<?> testClass) {
        IfProfileValue ifProfileValue = testClass.getAnnotation(IfProfileValue.class);
        boolean classLevelEnabled = ProfileValueUtils.isTestEnabledInThisEnvironment(profileValueSource, ifProfileValue);
        if (classLevelEnabled) {
            ifProfileValue = testMethod.getAnnotation(IfProfileValue.class);
            return ProfileValueUtils.isTestEnabledInThisEnvironment(profileValueSource, ifProfileValue);
        }
        return false;
    }

    private static boolean isTestEnabledInThisEnvironment(ProfileValueSource profileValueSource, IfProfileValue ifProfileValue) {
        if (ifProfileValue == null) {
            return true;
        }
        String environmentValue = profileValueSource.get(ifProfileValue.name());
        String[] annotatedValues = ifProfileValue.values();
        if (StringUtils.hasLength(ifProfileValue.value())) {
            if (annotatedValues.length > 0) {
                throw new IllegalArgumentException("Setting both the 'value' and 'values' attributes of @IfProfileValue is not allowed: choose one or the other.");
            }
            annotatedValues = new String[]{ifProfileValue.value()};
        }
        String[] stringArray = annotatedValues;
        int n = annotatedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (ObjectUtils.nullSafeEquals(value, environmentValue)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

