/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.config;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class Jaxb2MarshallerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String JAXB2_MARSHALLER_CLASS_NAME = "org.springframework.oxm.jaxb.Jaxb2Marshaller";

    Jaxb2MarshallerBeanDefinitionParser() {
    }

    protected String getBeanClassName(Element element) {
        return JAXB2_MARSHALLER_CLASS_NAME;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
        List<Element> classes;
        String contextPath = element.getAttribute("contextPath");
        if (StringUtils.hasText(contextPath)) {
            beanDefinitionBuilder.addPropertyValue("contextPath", contextPath);
        }
        if (!(classes = DomUtils.getChildElementsByTagName(element, "class-to-be-bound")).isEmpty()) {
            ManagedList<String> classesToBeBound = new ManagedList<String>(classes.size());
            for (Element classToBeBound : classes) {
                String className = classToBeBound.getAttribute("name");
                classesToBeBound.add(className);
            }
            beanDefinitionBuilder.addPropertyValue("classesToBeBound", classesToBeBound);
        }
    }
}

