/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mock.web.DelegatingServletOutputStream;
import org.springframework.mock.web.HeaderValueHolder;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletResponse
implements HttpServletResponse {
    public static final int DEFAULT_SERVER_PORT = 80;
    private static final String CHARSET_PREFIX = "charset=";
    private boolean outputStreamAccessAllowed = true;
    private boolean writerAccessAllowed = true;
    private String characterEncoding = "ISO-8859-1";
    private final ByteArrayOutputStream content = new ByteArrayOutputStream();
    private final ServletOutputStream outputStream = new ResponseServletOutputStream(this.content);
    private PrintWriter writer;
    private int contentLength = 0;
    private String contentType;
    private int bufferSize = 4096;
    private boolean committed;
    private Locale locale = Locale.getDefault();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, HeaderValueHolder> headers = new LinkedCaseInsensitiveMap<HeaderValueHolder>();
    private int status = 200;
    private String errorMessage;
    private String redirectedUrl;
    private String forwardedUrl;
    private String includedUrl;

    public void setOutputStreamAccessAllowed(boolean outputStreamAccessAllowed) {
        this.outputStreamAccessAllowed = outputStreamAccessAllowed;
    }

    public boolean isOutputStreamAccessAllowed() {
        return this.outputStreamAccessAllowed;
    }

    public void setWriterAccessAllowed(boolean writerAccessAllowed) {
        this.writerAccessAllowed = writerAccessAllowed;
    }

    public boolean isWriterAccessAllowed() {
        return this.writerAccessAllowed;
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public ServletOutputStream getOutputStream() {
        if (!this.outputStreamAccessAllowed) {
            throw new IllegalStateException("OutputStream access not allowed");
        }
        return this.outputStream;
    }

    @Override
    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (!this.writerAccessAllowed) {
            throw new IllegalStateException("Writer access not allowed");
        }
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding != null ? new OutputStreamWriter((OutputStream)this.content, this.characterEncoding) : new OutputStreamWriter(this.content);
            this.writer = new ResponsePrintWriter(targetWriter);
        }
        return this.writer;
    }

    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.content.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        this.flushBuffer();
        return this.characterEncoding != null ? this.content.toString(this.characterEncoding) : this.content.toString();
    }

    @Override
    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public void setContentType(String contentType) {
        int charsetIndex;
        this.contentType = contentType;
        if (contentType != null && (charsetIndex = contentType.toLowerCase().indexOf(CHARSET_PREFIX)) != -1) {
            String encoding = contentType.substring(charsetIndex + CHARSET_PREFIX.length());
            this.setCharacterEncoding(encoding);
        }
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void flushBuffer() {
        this.setCommitted(true);
    }

    @Override
    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.content.reset();
    }

    private void setCommittedIfBufferSizeExceeded() {
        int bufSize = this.getBufferSize();
        if (bufSize > 0 && this.content.size() > bufSize) {
            this.setCommitted(true);
        }
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentLength = 0;
        this.contentType = null;
        this.locale = null;
        this.cookies.clear();
        this.headers.clear();
        this.status = 200;
        this.errorMessage = null;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void addCookie(Cookie cookie) {
        Assert.notNull(cookie, "Cookie must not be null");
        this.cookies.add(cookie);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public Cookie getCookie(String name) {
        Assert.notNull(name, "Cookie name must not be null");
        for (Cookie cookie : this.cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public boolean containsHeader(String name) {
        return HeaderValueHolder.getByName(this.headers, name) != null;
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Object getHeader(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getValue() : null;
    }

    public List<Object> getHeaders(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getValues() : Collections.emptyList();
    }

    @Override
    public String encodeURL(String url) {
        return url;
    }

    @Override
    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    @Override
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    @Override
    public void sendError(int status, String errorMessage) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.errorMessage = errorMessage;
        this.setCommitted(true);
    }

    @Override
    public void sendError(int status) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.setCommitted(true);
    }

    @Override
    public void sendRedirect(String url) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        Assert.notNull(url, "Redirect URL must not be null");
        this.redirectedUrl = url;
        this.setCommitted(true);
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    @Override
    public void setDateHeader(String name, long value) {
        this.setHeaderValue(name, value);
    }

    @Override
    public void addDateHeader(String name, long value) {
        this.addHeaderValue(name, value);
    }

    @Override
    public void setHeader(String name, String value) {
        this.setHeaderValue(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.addHeaderValue(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.setHeaderValue(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.addHeaderValue(name, value);
    }

    private void setHeaderValue(String name, Object value) {
        this.doAddHeaderValue(name, value, true);
    }

    private void addHeaderValue(String name, Object value) {
        this.doAddHeaderValue(name, value, false);
    }

    private void doAddHeaderValue(String name, Object value, boolean replace) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Assert.notNull(value, "Header value must not be null");
        if (header == null) {
            header = new HeaderValueHolder();
            this.headers.put(name, header);
        }
        if (replace) {
            header.setValue(value);
        } else {
            header.addValue(value);
        }
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public void setStatus(int status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setForwardedUrl(String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    public String getForwardedUrl() {
        return this.forwardedUrl;
    }

    public void setIncludedUrl(String includedUrl) {
        this.includedUrl = includedUrl;
    }

    public String getIncludedUrl() {
        return this.includedUrl;
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        public ResponsePrintWriter(Writer out) {
            super(out, true);
        }

        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        public void write(String s, int off, int len) {
            super.write(s, off, len);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        public void write(int c) {
            super.write(c);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        public void flush() {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }
    }

    private class ResponseServletOutputStream
    extends DelegatingServletOutputStream {
        public ResponseServletOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            super.write(b);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        public void flush() throws IOException {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }
    }
}

