/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.lob.AbstractLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.PassThroughBlob;
import org.springframework.jdbc.support.lob.PassThroughClob;

public class DefaultLobHandler
extends AbstractLobHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean wrapAsLob = false;
    private boolean streamAsLob = false;

    public void setWrapAsLob(boolean wrapAsLob) {
        this.wrapAsLob = wrapAsLob;
    }

    public void setStreamAsLob(boolean streamAsLob) {
        this.streamAsLob = streamAsLob;
    }

    public byte[] getBlobAsBytes(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning BLOB as bytes");
        if (this.wrapAsLob) {
            Blob blob = rs.getBlob(columnIndex);
            return blob.getBytes(1L, (int)blob.length());
        }
        return rs.getBytes(columnIndex);
    }

    public InputStream getBlobAsBinaryStream(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning BLOB as binary stream");
        if (this.wrapAsLob) {
            Blob blob = rs.getBlob(columnIndex);
            return blob.getBinaryStream();
        }
        return rs.getBinaryStream(columnIndex);
    }

    public String getClobAsString(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning CLOB as string");
        if (this.wrapAsLob) {
            Clob clob = rs.getClob(columnIndex);
            return clob.getSubString(1L, (int)clob.length());
        }
        return rs.getString(columnIndex);
    }

    public InputStream getClobAsAsciiStream(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning CLOB as ASCII stream");
        if (this.wrapAsLob) {
            Clob clob = rs.getClob(columnIndex);
            return clob.getAsciiStream();
        }
        return rs.getAsciiStream(columnIndex);
    }

    public Reader getClobAsCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning CLOB as character stream");
        if (this.wrapAsLob) {
            Clob clob = rs.getClob(columnIndex);
            return clob.getCharacterStream();
        }
        return rs.getCharacterStream(columnIndex);
    }

    public LobCreator getLobCreator() {
        return new DefaultLobCreator();
    }

    protected class DefaultLobCreator
    implements LobCreator {
        protected DefaultLobCreator() {
        }

        public void setBlobAsBytes(PreparedStatement ps, int paramIndex, byte[] content) throws SQLException {
            if (DefaultLobHandler.this.streamAsLob) {
                if (content != null) {
                    ps.setBlob(paramIndex, new ByteArrayInputStream(content), content.length);
                } else {
                    ps.setBlob(paramIndex, (Blob)null);
                }
            } else if (DefaultLobHandler.this.wrapAsLob) {
                if (content != null) {
                    ps.setBlob(paramIndex, new PassThroughBlob(content));
                } else {
                    ps.setBlob(paramIndex, (Blob)null);
                }
            } else {
                ps.setBytes(paramIndex, content);
            }
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(content != null ? "Set bytes for BLOB with length " + content.length : "Set BLOB to null");
            }
        }

        public void setBlobAsBinaryStream(PreparedStatement ps, int paramIndex, InputStream binaryStream, int contentLength) throws SQLException {
            if (DefaultLobHandler.this.streamAsLob) {
                if (binaryStream != null) {
                    ps.setBlob(paramIndex, binaryStream, contentLength);
                } else {
                    ps.setBlob(paramIndex, (Blob)null);
                }
            } else if (DefaultLobHandler.this.wrapAsLob) {
                if (binaryStream != null) {
                    ps.setBlob(paramIndex, new PassThroughBlob(binaryStream, contentLength));
                } else {
                    ps.setBlob(paramIndex, (Blob)null);
                }
            } else {
                ps.setBinaryStream(paramIndex, binaryStream, contentLength);
            }
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(binaryStream != null ? "Set binary stream for BLOB with length " + contentLength : "Set BLOB to null");
            }
        }

        public void setClobAsString(PreparedStatement ps, int paramIndex, String content) throws SQLException {
            if (DefaultLobHandler.this.streamAsLob) {
                if (content != null) {
                    ps.setClob(paramIndex, new StringReader(content), content.length());
                } else {
                    ps.setClob(paramIndex, (Clob)null);
                }
            } else if (DefaultLobHandler.this.wrapAsLob) {
                if (content != null) {
                    ps.setClob(paramIndex, new PassThroughClob(content));
                } else {
                    ps.setClob(paramIndex, (Clob)null);
                }
            } else {
                ps.setString(paramIndex, content);
            }
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(content != null ? "Set string for CLOB with length " + content.length() : "Set CLOB to null");
            }
        }

        public void setClobAsAsciiStream(PreparedStatement ps, int paramIndex, InputStream asciiStream, int contentLength) throws SQLException {
            if (DefaultLobHandler.this.streamAsLob || DefaultLobHandler.this.wrapAsLob) {
                if (asciiStream != null) {
                    try {
                        InputStreamReader reader = new InputStreamReader(asciiStream, "US-ASCII");
                        if (DefaultLobHandler.this.streamAsLob) {
                            ps.setClob(paramIndex, reader, contentLength);
                        }
                        ps.setClob(paramIndex, new PassThroughClob(reader, contentLength));
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new SQLException("US-ASCII encoding not supported: " + ex);
                    }
                } else {
                    ps.setClob(paramIndex, (Clob)null);
                }
            } else {
                ps.setAsciiStream(paramIndex, asciiStream, contentLength);
            }
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(asciiStream != null ? "Set ASCII stream for CLOB with length " + contentLength : "Set CLOB to null");
            }
        }

        public void setClobAsCharacterStream(PreparedStatement ps, int paramIndex, Reader characterStream, int contentLength) throws SQLException {
            if (DefaultLobHandler.this.streamAsLob) {
                if (characterStream != null) {
                    ps.setClob(paramIndex, characterStream, contentLength);
                } else {
                    ps.setClob(paramIndex, (Clob)null);
                }
            } else if (DefaultLobHandler.this.wrapAsLob) {
                if (characterStream != null) {
                    ps.setClob(paramIndex, new PassThroughClob(characterStream, contentLength));
                } else {
                    ps.setClob(paramIndex, (Clob)null);
                }
            } else {
                ps.setCharacterStream(paramIndex, characterStream, contentLength);
            }
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(characterStream != null ? "Set character stream for CLOB with length " + contentLength : "Set CLOB to null");
            }
        }

        public void close() {
        }
    }
}

