/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.impl.io.VFMemoryStorageFactory;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.OutputStreamFactory;

final class DerbyEmbeddedDatabaseConfigurer
implements EmbeddedDatabaseConfigurer {
    private static final Log logger = LogFactory.getLog(DerbyEmbeddedDatabaseConfigurer.class);
    private static final String URL_TEMPLATE = "jdbc:derby:memory:%s;%s";
    private static final String SHUTDOWN_CODE = "08006";
    private static DerbyEmbeddedDatabaseConfigurer INSTANCE;

    public static synchronized DerbyEmbeddedDatabaseConfigurer getInstance() throws ClassNotFoundException {
        if (INSTANCE == null) {
            System.setProperty("derby.stream.error.method", String.valueOf(OutputStreamFactory.class.getName()) + ".getNoopOutputStream");
            INSTANCE = new DerbyEmbeddedDatabaseConfigurer();
        }
        return INSTANCE;
    }

    private DerbyEmbeddedDatabaseConfigurer() {
    }

    public void configureConnectionProperties(ConnectionProperties properties, String databaseName) {
        properties.setDriverClass(EmbeddedDriver.class);
        properties.setUrl(String.format(URL_TEMPLATE, databaseName, "create=true"));
        properties.setUsername("sa");
        properties.setPassword("");
    }

    public void shutdown(DataSource dataSource, String databaseName) {
        try {
            new EmbeddedDriver().connect(String.format(URL_TEMPLATE, databaseName, "shutdown=true"), new Properties());
        }
        catch (SQLException ex) {
            if (SHUTDOWN_CODE.equals(ex.getSQLState())) {
                this.purgeDatabase(databaseName);
            }
            logger.warn("Could not shutdown in-memory Derby database", ex);
        }
    }

    private void purgeDatabase(String databaseName) {
        try {
            VFMemoryStorageFactory.purgeDatabase((String)new File(databaseName).getCanonicalPath());
        }
        catch (IOException ex) {
            logger.warn("Could not purge in-memory Derby database", ex);
        }
    }
}

