/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayHttpMessageConverter
extends AbstractHttpMessageConverter<byte[]> {
    public ByteArrayHttpMessageConverter() {
        super(new MediaType("application", "octet-stream"), MediaType.ALL);
    }

    @Override
    public boolean supports(Class<? extends byte[]> clazz) {
        return byte[].class.equals(clazz);
    }

    @Override
    public byte[] readInternal(Class<byte[]> clazz, HttpInputMessage inputMessage) throws IOException {
        long contentLength = inputMessage.getHeaders().getContentLength();
        if (contentLength >= 0L) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream((int)contentLength);
            FileCopyUtils.copy(inputMessage.getBody(), (OutputStream)bos);
            return bos.toByteArray();
        }
        return FileCopyUtils.copyToByteArray(inputMessage.getBody());
    }

    @Override
    protected Long getContentLength(byte[] bytes, MediaType contentType) {
        return bytes.length;
    }

    @Override
    protected void writeInternal(byte[] bytes, HttpOutputMessage outputMessage) throws IOException {
        FileCopyUtils.copy(bytes, outputMessage.getBody());
    }
}

