/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpResponse;
import org.springframework.util.FileCopyUtils;

final class SimpleClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpURLConnection connection;

    SimpleClientHttpRequest(HttpURLConnection connection) {
        this.connection = connection;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.connection.getRequestMethod());
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            for (String headerValue : entry.getValue()) {
                this.connection.addRequestProperty(headerName, headerValue);
            }
        }
        this.connection.connect();
        if (bufferedOutput.length > 0) {
            FileCopyUtils.copy(bufferedOutput, this.connection.getOutputStream());
        }
        return new SimpleClientHttpResponse(this.connection);
    }
}

