/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.asm.ClassReader;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.AnnotationMetadataReadingVisitor;
import org.springframework.core.type.classreading.ClassMetadataReadingVisitor;
import org.springframework.core.type.classreading.MetadataReader;

final class SimpleMetadataReader
implements MetadataReader {
    private final Resource resource;
    private final ClassReader classReader;
    private final ClassLoader classLoader;
    private ClassMetadata classMetadata;
    private AnnotationMetadata annotationMetadata;

    SimpleMetadataReader(Resource resource, ClassLoader classLoader) throws IOException {
        this.resource = resource;
        InputStream is = this.resource.getInputStream();
        try {
            this.classReader = new ClassReader(is);
        }
        finally {
            is.close();
        }
        this.classLoader = classLoader;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ClassMetadata getClassMetadata() {
        if (this.classMetadata == null) {
            ClassMetadataReadingVisitor visitor = new ClassMetadataReadingVisitor();
            this.classReader.accept(visitor, true);
            this.classMetadata = visitor;
        }
        return this.classMetadata;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        if (this.annotationMetadata == null) {
            AnnotationMetadataReadingVisitor visitor = new AnnotationMetadataReadingVisitor(this.classLoader);
            this.classReader.accept(visitor, true);
            this.annotationMetadata = visitor;
            this.classMetadata = visitor;
        }
        return this.annotationMetadata;
    }
}

