/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import net.sf.ehcache.constructs.blocking.UpdatingSelfPopulatingCache;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class EhCacheFactoryBean
implements FactoryBean,
BeanNameAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;
    private String cacheName;
    private int maxElementsInMemory = 10000;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.LRU;
    private boolean overflowToDisk = true;
    private String diskStorePath;
    private boolean eternal = false;
    private int timeToLive = 120;
    private int timeToIdle = 120;
    private boolean diskPersistent = false;
    private int diskExpiryThreadIntervalSeconds = 120;
    private boolean blocking = false;
    private CacheEntryFactory cacheEntryFactory;
    private String beanName;
    private Ehcache cache;
    static /* synthetic */ Class class$net$sf$ehcache$Ehcache;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public void setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        Assert.notNull(memoryStoreEvictionPolicy, "memoryStoreEvictionPolicy must not be null");
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public void setDiskStorePath(String diskStorePath) {
        this.diskStorePath = diskStorePath;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToIdle(int timeToIdle) {
        this.timeToIdle = timeToIdle;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setCacheEntryFactory(CacheEntryFactory cacheEntryFactory) {
        this.cacheEntryFactory = cacheEntryFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws CacheException, IOException {
        if (this.cacheManager == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using default EHCache CacheManager for cache region '" + this.cacheName + "'");
            }
            this.cacheManager = CacheManager.getInstance();
        }
        if (this.cacheName == null) {
            this.cacheName = this.beanName;
        }
        if (this.cacheManager.cacheExists(this.cacheName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using existing EHCache cache region '" + this.cacheName + "'");
            }
            this.cache = this.cacheManager.getEhcache(this.cacheName);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating new EHCache cache region '" + this.cacheName + "'");
            }
            Cache rawCache = this.createCache();
            this.cacheManager.addCache(rawCache);
            Ehcache decoratedCache = this.decorateCache(rawCache);
            this.cacheManager.replaceCacheWithDecoratedCache((Ehcache)rawCache, decoratedCache);
            this.cache = decoratedCache;
        }
    }

    private Cache createCache() {
        return new Cache(this.cacheName, this.maxElementsInMemory, this.memoryStoreEvictionPolicy, this.overflowToDisk, this.diskStorePath, this.eternal, (long)this.timeToLive, (long)this.timeToIdle, this.diskPersistent, (long)this.diskExpiryThreadIntervalSeconds, null);
    }

    protected Ehcache decorateCache(Cache cache) {
        if (this.cacheEntryFactory != null) {
            if (this.cacheEntryFactory instanceof UpdatingCacheEntryFactory) {
                return new UpdatingSelfPopulatingCache((Ehcache)cache, (UpdatingCacheEntryFactory)this.cacheEntryFactory);
            }
            return new SelfPopulatingCache((Ehcache)cache, this.cacheEntryFactory);
        }
        if (this.blocking) {
            return new BlockingCache((Ehcache)cache);
        }
        return cache;
    }

    public Object getObject() {
        return this.cache;
    }

    public Class getObjectType() {
        return this.cache != null ? this.cache.getClass() : (class$net$sf$ehcache$Ehcache == null ? (class$net$sf$ehcache$Ehcache = EhCacheFactoryBean.class$("net.sf.ehcache.Ehcache")) : class$net$sf$ehcache$Ehcache);
    }

    public boolean isSingleton() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

