/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import org.aopalliance.aop.Advice;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.Assert;

public abstract class AbstractBeanFactoryPointcutAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private String adviceBeanName;
    private BeanFactory beanFactory;
    private Advice advice;
    private final Object adviceMonitor = new Object();

    public void setAdviceBeanName(String adviceBeanName) {
        this.adviceBeanName = adviceBeanName;
    }

    public String getAdviceBeanName() {
        return this.adviceBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Advice getAdvice() {
        Object object = this.adviceMonitor;
        synchronized (object) {
            if (this.advice == null && this.adviceBeanName != null) {
                Assert.state(this.beanFactory != null, "BeanFactory must be set to resolve 'adviceBeanName'");
                this.advice = this.beanFactory.getBean(this.adviceBeanName, Advice.class);
            }
            return this.advice;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": advice bean '" + this.getAdviceBeanName() + "'";
    }
}

