/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.util.HashSet;
import org.quartz.impl.jdbcjobstore.Constants;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.TablePrefixAware;
import org.quartz.impl.jdbcjobstore.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBSemaphore
implements Semaphore,
Constants,
StdJDBCConstants,
TablePrefixAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    ThreadLocal lockOwners = new ThreadLocal();
    private String sql;
    private String tablePrefix;
    private String expandedSQL;

    public DBSemaphore(String tablePrefix, String sql, String defaultSQL) {
        this.sql = defaultSQL;
        this.tablePrefix = tablePrefix;
        this.setSQL(sql);
    }

    protected Logger getLog() {
        return this.log;
    }

    private HashSet getThreadLocks() {
        HashSet threadLocks = (HashSet)this.lockOwners.get();
        if (threadLocks == null) {
            threadLocks = new HashSet();
            this.lockOwners.set(threadLocks);
        }
        return threadLocks;
    }

    protected abstract void executeSQL(Connection var1, String var2, String var3) throws LockException;

    public boolean obtainLock(Connection conn, String lockName) throws LockException {
        lockName = lockName.intern();
        Logger log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug("Lock '" + lockName + "' is desired by: " + Thread.currentThread().getName());
        }
        if (!this.isLockOwner(conn, lockName)) {
            this.executeSQL(conn, lockName, this.expandedSQL);
            if (log.isDebugEnabled()) {
                log.debug("Lock '" + lockName + "' given to: " + Thread.currentThread().getName());
            }
            this.getThreadLocks().add(lockName);
        } else if (log.isDebugEnabled()) {
            log.debug("Lock '" + lockName + "' Is already owned by: " + Thread.currentThread().getName());
        }
        return true;
    }

    public void releaseLock(Connection conn, String lockName) {
        if (this.isLockOwner(conn, lockName = lockName.intern())) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Lock '" + lockName + "' returned by: " + Thread.currentThread().getName());
            }
            this.getThreadLocks().remove(lockName);
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().warn("Lock '" + lockName + "' attempt to return by: " + Thread.currentThread().getName() + " -- but not owner!", new Exception("stack-trace of wrongful returner"));
        }
    }

    public boolean isLockOwner(Connection conn, String lockName) {
        lockName = lockName.intern();
        return this.getThreadLocks().contains(lockName);
    }

    public boolean requiresConnection() {
        return true;
    }

    protected String getSQL() {
        return this.sql;
    }

    protected void setSQL(String sql) {
        if (sql != null && sql.trim().length() != 0) {
            this.sql = sql;
        }
        this.setExpandedSQL();
    }

    private void setExpandedSQL() {
        if (this.getTablePrefix() != null) {
            this.expandedSQL = Util.rtp(this.sql, this.getTablePrefix());
        }
    }

    protected String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
        this.setExpandedSQL();
    }
}

