/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.session;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.ktde.util.session.GenericSession;
import org.ktde.util.session.GenericSessionAccessor;
import org.ktde.util.session.SessionNotValidException;

public class HessianServletGenericSessionAccessor
extends GenericSession
implements GenericSessionAccessor {
    private HttpSession servletSession;
    private boolean valid;

    public HessianServletGenericSessionAccessor(ServletRequest arg0) {
        this.servletSession = ((HttpServletRequest)arg0).getSession(true);
        String testRemoteHost = (String)this.getProperty("remoteHost");
        String remoteHost = ((HttpServletRequest)arg0).getHeader("x-forwarded-for");
        if (remoteHost == null) {
            remoteHost = arg0.getRemoteHost();
        }
        if (testRemoteHost == null) {
            this.setProperty("remoteHost", remoteHost);
            this.valid = true;
        } else {
            this.valid = testRemoteHost.equals(remoteHost);
        }
    }

    @Override
    public synchronized GenericSession createSession() {
        return this;
    }

    @Override
    public synchronized Object getProperty(String name) {
        return this.servletSession.getAttribute(name);
    }

    @Override
    public synchronized void removeProperty(String name) {
        this.servletSession.removeAttribute(name);
    }

    @Override
    public synchronized void setProperty(String name, Object value) {
        this.servletSession.setAttribute(name, value);
    }

    @Override
    public void validateSession() throws SessionNotValidException {
    }

    @Override
    public Map<String, Object> getProperties() {
        Enumeration attributeNames = this.servletSession.getAttributeNames();
        HashMap<String, Object> props = new HashMap<String, Object>();
        while (attributeNames.hasMoreElements()) {
            String key = (String)attributeNames.nextElement();
            Object attribute = this.servletSession.getAttribute(key);
            props.put(key, attribute);
        }
        return props;
    }

    @Override
    public void setAllProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.servletSession.setAttribute(entry.getKey(), entry.getValue());
        }
    }
}

