/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.session;

import java.util.Map;
import org.ktde.util.session.GenericSessionAccessor;
import org.ktde.util.session.SessionNotValidException;

public abstract class GenericSession {
    public static final String INCOMING_HOST_KEY = "INCOMING_HOST_KEY";
    private static ThreadLocal<GenericSession> session = new ThreadLocal();

    public static GenericSession getCurrentSession() {
        return session.get();
    }

    public static void removeCurrentSession() {
        session.remove();
    }

    public static void generateSession(GenericSessionAccessor accessor) throws SessionNotValidException {
        GenericSession currentSession = accessor.createSession();
        session.set(currentSession);
        currentSession.validateSession();
    }

    public abstract Object getProperty(String var1);

    public abstract void setProperty(String var1, Object var2);

    public abstract void removeProperty(String var1);

    public abstract void validateSession() throws SessionNotValidException;

    public abstract Map<String, Object> getProperties();

    public abstract void setAllProperties(Map<String, Object> var1);
}

