/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.polygon;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ktde.util.conversions.IteratorIterable;
import org.ktde.util.datatypes.ArrayHelper;
import org.ktde.util.datatypes.Range;

public class TreePartition {
    private List<TreePartition> children;
    private Range range;

    public TreePartition(Range range) {
        this.range = range;
    }

    public TreePartition(TreePartition ... treePartition) {
        this.range = new Range(treePartition[0].range.getFrom(), treePartition[treePartition.length - 1].range.getTo());
        this.children = new LinkedList<TreePartition>();
        for (TreePartition treePartition2 : treePartition) {
            this.children.add(treePartition2);
        }
    }

    public Range getRange() {
        return this.range;
    }

    public void addChild(TreePartition child) {
        if (this.children == null) {
            this.children = new LinkedList<TreePartition>();
        }
        this.children.add(child);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.children).append(this.range).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TreePartition) {
            TreePartition treepart = (TreePartition)obj;
            return new EqualsBuilder().append(treepart.children, this.children).append(treepart.range, this.range).isEquals();
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, "");
        return builder.toString();
    }

    private void toString(StringBuilder builder, String tab) {
        if (this.children == null) {
            builder.append(tab + "TreePartition(" + this.range + ")");
        } else {
            builder.append(tab + "TreePartition(" + this.range + "\n");
            String ntab = tab + "\t";
            for (TreePartition child : this.children) {
                child.toString(builder, ntab);
                builder.append("\n");
            }
            builder.append(tab + ")");
        }
    }

    public Iterable<? extends TreePartition> iterateLeafs() {
        return new IteratorIterable<TreePartition>(this.getLeafIterator());
    }

    public Iterable<? extends TreePartition> iterateNodes() {
        return new IteratorIterable<TreePartition>(this.getNodeIterator());
    }

    public Iterator<? extends TreePartition> getLeafIterator() {
        return new NodeIterator(true);
    }

    public Iterator<? extends TreePartition> getNodeIterator() {
        return new NodeIterator(false);
    }

    public boolean hasChildren() {
        return !ArrayHelper.isEmpty(this.children);
    }

    public TreePartition getChildAt(int index) {
        return this.children.get(index);
    }

    public int countChildren() {
        return this.children.size();
    }

    private class NodeIterator
    implements Iterator<TreePartition> {
        private Iterator<TreePartition> childIterator;
        private Iterator<TreePartition> subIterator;
        boolean visited;
        boolean onlyLeafs;

        public NodeIterator(boolean onlyLeafs) {
            if (TreePartition.this.hasChildren()) {
                this.visited = onlyLeafs;
                this.childIterator = TreePartition.this.children.iterator();
            }
            this.onlyLeafs = onlyLeafs;
        }

        @Override
        public boolean hasNext() {
            return !this.visited || this.childIterator != null && this.childIterator.hasNext() || this.subIterator != null && this.subIterator.hasNext();
        }

        @Override
        public TreePartition next() {
            if (!this.visited) {
                this.visited = true;
                return TreePartition.this;
            }
            if (this.childIterator == null) {
                throw new NoSuchElementException("No elements left");
            }
            if (this.subIterator == null) {
                TreePartition treePartition = this.childIterator.next();
                treePartition.getClass();
                this.subIterator = treePartition.new NodeIterator(this.onlyLeafs);
            }
            TreePartition next = this.subIterator.next();
            if (!this.subIterator.hasNext()) {
                this.subIterator = null;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove tree leafs");
        }
    }
}

