/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.polygon;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.datatypes.ArrayHelper;
import org.ktde.util.datatypes.Range;
import org.ktde.util.polygon.LogTree;
import org.ktde.util.polygon.TreePartition;

public class Partitioner {
    public static TreePartition treePartition(Object[] array) {
        if (ArrayHelper.isEmpty(array)) {
            return null;
        }
        return Partitioner.treePartition(Arrays.asList(array));
    }

    public static TreePartition treePartition(List<?> array) {
        return Partitioner.treePartition(array, 2);
    }

    public static TreePartition treePartition(Object[] array, int maxChilds) {
        if (ArrayHelper.isEmpty(array)) {
            return null;
        }
        return Partitioner.treePartition(Arrays.asList(array), maxChilds);
    }

    public static TreePartition treePartition(List<?> array, int maxChilds) {
        if (ArrayHelper.isEmpty(array)) {
            return null;
        }
        if (maxChilds < 2) {
            throw new IllegalArgumentException("mindestens zwei Kinder m\u00fcssen in Partition erlaubt sein");
        }
        int countDifferent = 1;
        Object last = array.get(0);
        LinkedList<Integer> partitionChange = new LinkedList<Integer>();
        for (int i = 0; i < array.size(); ++i) {
            Object value = array.get(i);
            if (new EqualsBuilder().append(last, value).isEquals()) continue;
            partitionChange.add(i);
            ++countDifferent;
            last = value;
        }
        partitionChange.add(array.size());
        LinkedList<Range> partitions = new LinkedList<Range>();
        int i = 0;
        for (Integer change : partitionChange) {
            partitions.add(new Range(i, change - 1));
            i = change;
        }
        TreePartition result = new TreePartition(new Range(0, array.size() - 1));
        if (countDifferent > maxChilds) {
            LogTree logTree = new LogTree(countDifferent, maxChilds);
            System.err.println("build partitions ");
            Partitioner.buildPartitions(partitions, logTree, result);
        } else if (partitions.size() > 1) {
            for (Range range : partitions) {
                result.addChild(new TreePartition(range));
            }
        }
        return result;
    }

    private static void buildPartitions(List<Range> partitions, LogTree logTree, TreePartition result) {
        for (LogTree.Child child : logTree.getChildren()) {
            if (child instanceof LogTree.SubTree) {
                LogTree.SubTree subTree = (LogTree.SubTree)child;
                Range logRange = subTree.getRange();
                Range startRange = partitions.get(logRange.getFrom());
                Range endRange = partitions.get(logRange.getTo());
                Range treeRange = new Range(startRange.getFrom(), endRange.getTo());
                TreePartition subTreeNode = new TreePartition(treeRange);
                Partitioner.buildPartitions(partitions, subTree.getTree(), subTreeNode);
                result.addChild(subTreeNode);
                continue;
            }
            Range nodeRange = partitions.get(((LogTree.IndexChild)child).getIndex());
            Integer start = nodeRange.getFrom();
            Integer end = nodeRange.getTo();
            result.addChild(new TreePartition(new Range(start, end)));
        }
    }

    public static int findFirstPartitionStartOverlapping(List<Collection<?>> arrays) {
        int count = arrays.size();
        if (ArrayHelper.isEmpty(arrays.get(count - 1))) {
            int result;
            for (result = 0; result < count && ArrayHelper.isEmpty(arrays.get(result)); ++result) {
            }
            return result;
        }
        HashSet last = new HashSet();
        last.addAll(arrays.get(count - 1));
        int result = 0;
        for (int i = 0; i < count; ++i) {
            if (!ArrayHelper.isEmpty(arrays.get(i))) {
                for (Object item : arrays.get(i)) {
                    if (!last.contains(item)) continue;
                    break;
                }
            } else {
                result = i;
                break;
            }
            last.addAll(arrays.get(i));
        }
        return result;
    }
}

