/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.logging;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;

public class MethodInvocationLogger
implements MethodBeforeAdvice,
AfterReturningAdvice {
    private static final Logger logger = LoggerFactory.getLogger(MethodInvocationLogger.class);

    @Override
    public void before(Method method, Object[] args, Object object) throws Throwable {
        logger.debug("Beginning method: " + method.getName());
    }

    @Override
    public void afterReturning(Object returnValue, Method method, Object[] args, Object object) throws Throwable {
        String returnClass = returnValue == null ? "null" : returnValue.getClass().getName();
        logger.debug("Ending method: " + method.getName() + " with result of class " + returnClass);
    }
}

