/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.ktde.util.io.TcpClientHandler;

public abstract class TcpServer {
    private ServerSocket socket;
    private Thread acceptListener;
    protected boolean stopped;
    private List<TcpClientHandler> handlers = new ArrayList<TcpClientHandler>();

    public TcpServer(int port) throws IOException {
        this(new ServerSocket(port));
    }

    public TcpServer(int port, InetAddress bindaddress) throws IOException {
        this(new ServerSocket(port, 0, bindaddress));
    }

    public TcpServer(int port, int backlog, InetAddress bindaddress) throws IOException {
        this(new ServerSocket(port, backlog, bindaddress));
    }

    private TcpServer(ServerSocket socket) {
        this.socket = socket;
        this.acceptListener = new Thread(){

            @Override
            public void run() {
                while (!TcpServer.this.stopped) {
                    try {
                        Socket s = TcpServer.this.socket.accept();
                        System.out.println("Accepted from " + s.getInetAddress() + ":" + s.getPort());
                        TcpServer.this.acceptClient(s);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                System.err.println("Accept Listener stopped");
            }
        };
        this.acceptListener.start();
    }

    protected abstract TcpClientHandler getHandlerInstance(Socket var1) throws IOException;

    protected void acceptClient(Socket s) throws IOException {
        TcpClientHandler handlerInstance = this.getHandlerInstance(s);
        handlerInstance.start();
        this.handlers.add(handlerInstance);
    }

    public void shutdown() {
        this.stopped = true;
        this.acceptListener.interrupt();
        for (TcpClientHandler handler : this.handlers) {
            handler.disconnect();
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

