/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class ScrambledInputStream
extends InputStream {
    private InputStream delegate;
    private int[] phrase;
    private int phrasePosition;

    public ScrambledInputStream(InputStream delegate, byte[] phrase) {
        this.delegate = delegate;
        if (phrase == null || phrase.length == 0) {
            this.phrase = new int[]{0};
        } else {
            this.phrase = new int[phrase.length];
            for (int i = 0; i < phrase.length; ++i) {
                this.phrase[i] = ScrambledInputStream.byteToInt(phrase[i]);
            }
        }
        this.phrasePosition = 0;
    }

    public ScrambledInputStream(InputStream delegate, String phrase) {
        this(delegate, ScrambledInputStream.decodeUtf8WithoutWarning(phrase));
    }

    private static byte[] decodeUtf8WithoutWarning(String phrase) {
        try {
            return phrase.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    private byte scramble(byte b) {
        int i = ScrambledInputStream.byteToInt(b);
        int c = this.phrase[this.phrasePosition];
        this.phrasePosition = (this.phrasePosition + 1) % this.phrase.length;
        int r = i ^ c;
        return ScrambledInputStream.intToByte(r);
    }

    private static byte intToByte(int i) {
        byte b = 0;
        b = i < 128 ? (byte)i : (byte)(i - 256);
        return b;
    }

    private static int byteToInt(byte b) {
        int i = b;
        if (i < 0) {
            i += 128;
        }
        return i;
    }

    @Override
    public int read() throws IOException {
        int r = this.delegate.read();
        if (r != -1) {
            byte scrambled = this.scramble(ScrambledInputStream.intToByte(r));
            r = ScrambledInputStream.byteToInt(scrambled);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = this.delegate.read(b, off, len);
        if (res < len) {
            len = res;
        }
        for (int i = off; i < len; ++i) {
            b[i] = this.scramble(b[i]);
        }
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }
}

