/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import org.ktde.util.io.TcpClientHandler;

public abstract class ReaderTcpClientHandler
extends TcpClientHandler
implements Runnable {
    private Reader reader;
    private Writer writer;
    private boolean stopped;
    private int bufferSize = 2048;
    private Thread thread;
    private char[] contents;
    private int contentused;
    private boolean disconnect;

    public ReaderTcpClientHandler(Socket s) throws IOException {
        super(s);
    }

    @Override
    protected void start() throws IOException {
        this.reader = this.getReaderFromSocket(this.getSocket());
        this.writer = this.getWriterFromSocket(this.getSocket());
        this.contents = new char[0];
        this.contentused = 0;
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        char[] buffer = new char[this.bufferSize];
        while (!this.stopped) {
            try {
                int read = this.reader.read(buffer);
                if (read == -1) {
                    this.disconnect();
                    break;
                }
                int newContentSize = this.contents.length + read - this.contentused;
                char[] newContent = new char[newContentSize];
                System.arraycopy(this.contents, this.contentused, newContent, 0, this.contents.length - this.contentused);
                System.arraycopy(buffer, 0, newContent, this.contents.length - this.contentused, read);
                this.contents = newContent;
                this.contentused = this.processIncomingContent(this.contents);
                if (!this.disconnect) continue;
                this.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.disconnect();
                break;
            }
        }
    }

    protected abstract Reader getReaderFromSocket(Socket var1) throws IOException;

    protected abstract Writer getWriterFromSocket(Socket var1) throws IOException;

    protected abstract int processIncomingContent(char[] var1);

    protected void writeOutgointContent(char[] chars) throws IOException {
        this.writer.write(chars);
        this.writer.flush();
    }

    protected void writeOutgointContent(String string) throws IOException {
        this.writeOutgointContent(string.toCharArray());
    }

    @Override
    protected void informDisconnect() {
    }

    public void initDisconnect() {
        this.disconnect = true;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    @Override
    protected void disconnect() {
        try {
            if (this.contentused < this.contents.length) {
                char[] rest = new char[this.contents.length - this.contentused];
                System.arraycopy(this.contents, this.contentused, rest, 0, this.contents.length - this.contentused);
                this.processIncomingContent(rest);
            }
            this.stopped = true;
            this.thread.interrupt();
            this.informDisconnect();
            this.reader.close();
            this.writer.flush();
            this.writer.close();
            super.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

