/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class IoUtils {
    public static void copyProperties(File oldFile, File newFile, Properties overwrite, String comments) throws IOException {
        Properties newProperties = new Properties();
        if (oldFile != null && oldFile.exists()) {
            FileInputStream inputStream = new FileInputStream(oldFile);
            newProperties.load(inputStream);
            ((InputStream)inputStream).close();
        }
        if (overwrite != null) {
            Enumeration<Object> keys = overwrite.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                newProperties.setProperty(key, overwrite.getProperty(key));
            }
        }
        if (newFile == null) {
            newFile = oldFile;
        }
        FileOutputStream outputStream = new FileOutputStream(newFile);
        if (comments == null) {
            comments = "";
        }
        newProperties.store(outputStream, comments);
        outputStream.flush();
        ((OutputStream)outputStream).close();
    }

    public static Properties loadProperties(File propfile) throws IOException {
        Properties properties = new Properties();
        if (propfile != null && propfile.exists()) {
            FileInputStream inputStream = new FileInputStream(propfile);
            properties.load(inputStream);
            ((InputStream)inputStream).close();
            String parentfile = properties.getProperty("parentfile");
            if (parentfile != null) {
                properties = new Properties(IoUtils.loadProperties(new File(parentfile)));
                inputStream = new FileInputStream(propfile);
                properties.load(inputStream);
                ((InputStream)inputStream).close();
            }
        }
        return properties;
    }

    public static void download(URL url, OutputStream out) throws IOException {
        IoUtils.copyStream(url.openStream(), out);
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        IoUtils.copyStream(in, out, 1024, true);
    }

    public static void copyStream(InputStream in, OutputStream out, int bufsize) throws IOException {
        IoUtils.copyStream(in, out, bufsize, true);
    }

    public static void copyStream(InputStream in, OutputStream out, int bufsize, boolean closeOs) throws IOException {
        BufferedInputStream bufferedInputStream = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        BufferedOutputStream bufferedOutputStream = out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
        byte[] data = new byte[bufsize];
        int length = 0;
        while ((length = bufferedInputStream.read(data, 0, bufsize)) >= 0) {
            bufferedOutputStream.write(data, 0, length);
        }
        bufferedInputStream.close();
        bufferedOutputStream.flush();
        if (closeOs) {
            bufferedOutputStream.close();
        }
    }

    public static boolean diffStream(InputStream in1, InputStream in2) throws IOException {
        return IoUtils.diffStream(in1, in2, 4096);
    }

    public static boolean diffStream(InputStream in1, InputStream in2, int bufsize) throws IOException {
        BufferedInputStream bufferedInputStream1 = in1 instanceof BufferedInputStream ? (BufferedInputStream)in1 : new BufferedInputStream(in1);
        BufferedInputStream bufferedInputStream2 = in2 instanceof BufferedInputStream ? (BufferedInputStream)in2 : new BufferedInputStream(in2);
        byte[] data1 = new byte[bufsize];
        byte[] data2 = new byte[bufsize];
        int length1 = 0;
        boolean result = true;
        while ((length1 = bufferedInputStream1.read(data1, 0, bufsize)) >= 0) {
            int length2 = bufferedInputStream2.read(data2, 0, bufsize);
            if (length1 != length2) {
                result = false;
                break;
            }
            if (Arrays.equals(data1, data2)) continue;
            result = false;
            break;
        }
        if (result) {
            result = bufferedInputStream2.read() == -1;
        }
        bufferedInputStream1.close();
        bufferedInputStream2.close();
        return result;
    }

    public static String makeRelative(File cwd, File to) {
        File toAbsolute = to.getAbsoluteFile().getParentFile();
        LinkedList<String> cwdPath = new LinkedList<String>();
        LinkedList<String> toPath = new LinkedList<String>();
        for (File cwdAbsolute = cwd.getAbsoluteFile(); cwdAbsolute != null; cwdAbsolute = cwdAbsolute.getParentFile()) {
            cwdPath.add(0, cwdAbsolute.getName());
        }
        while (toAbsolute != null) {
            toPath.add(0, toAbsolute.getName());
            toAbsolute = toAbsolute.getParentFile();
        }
        while (cwdPath.size() > 0 && ((String)toPath.get(0)).equals(cwdPath.get(0))) {
            if (toPath.size() == 0) {
                toPath.add(".");
                break;
            }
            toPath.remove(0);
            cwdPath.remove(0);
        }
        StringBuilder builder = new StringBuilder();
        for (String string : cwdPath) {
            builder.append("../");
        }
        for (String string : toPath) {
            builder.append(string + "/");
        }
        builder.append(to.getName());
        return builder.toString();
    }

    public static List<File> find(File dir, FileFilter filter) {
        LinkedList<File> files = new LinkedList<File>();
        files.add(dir);
        IoUtils.find(files, filter);
        return files;
    }

    private static void find(List<File> files, FileFilter filter) {
        ListIterator<File> listIterator = files.listIterator();
        while (listIterator.hasNext()) {
            File[] children;
            File file = listIterator.next();
            boolean matches = false;
            matches = filter == null ? file.isFile() : filter.accept(file);
            if (!matches) {
                listIterator.remove();
            }
            if (!file.isDirectory()) continue;
            for (File file2 : children = file.listFiles()) {
                listIterator.add(file2);
                listIterator.previous();
            }
        }
    }

    public static List<File> find(File dir) {
        return IoUtils.find(dir, null);
    }

    public static void deleteRecursive(File file) {
        if (file.isDirectory()) {
            for (File cfile : file.listFiles()) {
                IoUtils.deleteRecursive(cfile);
            }
        }
        file.delete();
    }
}

