/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.ktde.util.StringUtil;

public class CsvWriter {
    private BufferedWriter writer;
    private char delim = (char)44;
    private char delimMask = '\u0000';
    private Character text = Character.valueOf('\"');
    private char textMask = (char)34;
    private char textMaskMask = '\u0000';
    private String lineSeparator = "\n";

    public CsvWriter(String file) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, false);
    }

    public CsvWriter(String file, boolean append) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(file, append), "UTF-8");
    }

    public CsvWriter(File file) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(file), "UTF-8");
    }

    public CsvWriter(String file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(file), encoding);
    }

    public CsvWriter(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(file), encoding);
    }

    public CsvWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    public CsvWriter(Writer writer) {
        this(new BufferedWriter(writer));
    }

    public CsvWriter(OutputStream os) throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter(os, "UTF-8")));
    }

    public CsvWriter(OutputStream os, String encoding) throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter(os, encoding)));
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public char getDelim() {
        return this.delim;
    }

    public void setDelim(char delim) {
        this.delim = delim;
    }

    public char getDelimMask() {
        return this.delimMask;
    }

    public void setDelimMask(char delimMask) {
        this.delimMask = delimMask;
    }

    public char getText() {
        return this.text.charValue();
    }

    public void setText(Character text) {
        this.text = text;
    }

    public char getTextMask() {
        return this.textMask;
    }

    public void setTextMask(char textMask) {
        this.textMask = textMask;
    }

    public char getTextMaskMask() {
        return this.textMaskMask;
    }

    public void setTextMaskMask(char textMaskMask) {
        this.textMaskMask = textMaskMask;
    }

    public synchronized void writeLine(List<String> list) throws IOException {
        boolean first = true;
        for (String string : list) {
            if (!first) {
                this.writer.write(this.delim);
            } else {
                first = false;
            }
            this.appendToken(this.writer, StringUtil.getNotNull(string));
        }
        this.writer.write(this.lineSeparator);
    }

    private void appendToken(Writer writer, String string) throws IOException {
        boolean masktext = false;
        boolean maskdelims = false;
        char[] chars = string.toCharArray();
        block3: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\n': 
                case '\r': {
                    masktext = true;
                    break block3;
                }
                default: {
                    if (c == this.delim) {
                        if (this.delimMask == '\u0000') {
                            masktext = true;
                            break block3;
                        }
                        maskdelims = true;
                        continue block3;
                    }
                    if (this.text != null && c == this.text.charValue()) {
                        masktext = true;
                        break block3;
                    }
                    if (c != this.delimMask) continue block3;
                    masktext = true;
                    break block3;
                }
            }
        }
        if (masktext) {
            writer.write(this.maskText(string));
        } else if (maskdelims) {
            writer.write(this.maskDelims(string));
        } else {
            writer.write(string);
        }
    }

    private String maskText(String string) {
        char[] chars = string.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 2);
        sb.append(this.text);
        for (char c : chars) {
            if (c == this.text.charValue()) {
                sb.append(this.textMask);
            } else if (c == this.textMask) {
                sb.append(this.textMaskMask);
            }
            sb.append(c);
        }
        sb.append(this.text);
        return sb.toString();
    }

    private String maskDelims(String string) {
        char[] chars = string.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 2);
        for (char c : chars) {
            if (c == this.delim) {
                sb.append(this.delimMask);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public synchronized void flush() throws IOException {
        this.writer.flush();
    }

    public synchronized void close() throws IOException {
        this.writer.close();
    }

    public synchronized void writeLines(Collection<List<String>> lines) throws IOException {
        for (List<String> line : lines) {
            this.writeLine(line);
        }
    }
}

