/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class CsvReader {
    public static final Character DEFAULT_DELIM = Character.valueOf(',');
    public static final Character DEFAULT_DELIM_MASK = Character.valueOf('\u0000');
    public static final Character DEFAULT_TEXT = Character.valueOf('\"');
    public static final Character DEFAULT_TEXT_MASK = Character.valueOf('\"');
    private BufferedReader reader;
    private Character delim = DEFAULT_DELIM;
    private Character delimMask = DEFAULT_DELIM_MASK;
    private Character text = DEFAULT_TEXT;
    private Character textMask = DEFAULT_TEXT_MASK;
    private int lineCount = 0;
    private boolean trim = false;

    public CsvReader(String file) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileInputStream(file), "UTF-8");
    }

    public CsvReader(File file) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileInputStream(file), "UTF-8");
    }

    public CsvReader(String file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileInputStream(file), encoding);
    }

    public CsvReader(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileInputStream(file), encoding);
    }

    public CsvReader(BufferedReader reader) {
        this.reader = reader;
    }

    public CsvReader(InputStream is) throws UnsupportedEncodingException {
        this(new BufferedReader(new InputStreamReader(is, "UTF-8")));
    }

    public CsvReader(InputStream is, String encoding) throws UnsupportedEncodingException {
        this(new BufferedReader(new InputStreamReader(is, encoding)));
    }

    public CsvReader(Reader reader) {
        this(new BufferedReader(reader));
    }

    public Character getDelim() {
        return this.delim;
    }

    public void setDelim(Character delim) {
        this.delim = delim;
    }

    public Character getDelimMask() {
        return this.delimMask;
    }

    public void setDelimMask(Character delimMask) {
        this.delimMask = delimMask;
    }

    public Character getText() {
        return this.text;
    }

    public void setText(Character text) {
        this.text = text;
    }

    public Character getTextMask() {
        return this.textMask;
    }

    public void setTextMask(Character textMask) {
        this.textMask = textMask;
    }

    public List<String> readLine() throws IOException {
        Tupel<List<String>, String> line = this.readLineWithSource();
        return line == null ? null : line.getElement1();
    }

    public Tupel<List<String>, String> readLineWithSource() throws IOException {
        String s = this.reader.readLine();
        if (s == null) {
            return null;
        }
        ++this.lineCount;
        char[] chars = s.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        StringBuilder sourceBuilder = new StringBuilder(s);
        int state = 0;
        int i = 0;
        while (state > -1) {
            Character c = i >= chars.length ? null : Character.valueOf(chars[i++]);
            switch (state) {
                case 0: {
                    if (c == null) {
                        list.add(this.trim ? token.toString().trim() : token.toString());
                        state = -1;
                        break;
                    }
                    char cValue = c.charValue();
                    if (this.delim != null && cValue == this.delim.charValue()) {
                        list.add(this.trim ? token.toString().trim() : token.toString());
                        token.setLength(0);
                        break;
                    }
                    if (this.text != null && cValue == this.text.charValue()) {
                        state = 2;
                        break;
                    }
                    if (this.delimMask != null && cValue == this.delimMask.charValue()) {
                        state = 1;
                        break;
                    }
                    token.append(c);
                    break;
                }
                case 1: {
                    token.append(c);
                    state = 0;
                    break;
                }
                case 2: {
                    if (c == null) {
                        token.append("\n");
                        sourceBuilder.append("\n");
                        s = this.reader.readLine();
                        ++this.lineCount;
                        if (s == null) {
                            throw new IOException("Unexpected end of stream: " + token);
                        }
                        sourceBuilder.append(s);
                        chars = s.toCharArray();
                        i = 0;
                        break;
                    }
                    char cValue = c.charValue();
                    if (this.text != null && this.textMask != null && this.text.charValue() == this.textMask.charValue() && cValue == this.text.charValue()) {
                        Character following;
                        Character c2 = following = i >= chars.length ? null : Character.valueOf(chars[i]);
                        if (following != null && following.charValue() == this.text.charValue()) {
                            state = 3;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    if (this.text != null && cValue == this.text.charValue()) {
                        state = 0;
                        break;
                    }
                    if (this.textMask != null && cValue == this.textMask.charValue()) {
                        state = 3;
                        break;
                    }
                    token.append(c);
                    break;
                }
                case 3: {
                    token.append(c);
                    state = 2;
                }
            }
        }
        return new Tupel<List<String>, String>(list, sourceBuilder.toString());
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int getCurrentLineCount() {
        return this.lineCount;
    }

    public static Map<String, Integer> getHeaderMapping(List<String> headLine) throws IOException {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        int count = 0;
        TreeSet<String> multiHeads = new TreeSet<String>();
        for (String head : headLine) {
            if (map.containsKey(head)) {
                multiHeads.add(head);
            }
            map.put(head, count);
            ++count;
        }
        if (!multiHeads.isEmpty()) {
            throw new MultipleOccuranceOfHeadException(multiHeads);
        }
        return map;
    }

    public static boolean isLineEmpty(List<String> line) {
        for (String string : line) {
            if (StringUtil.isBlank(string)) continue;
            return false;
        }
        return true;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public static class MultipleOccuranceOfHeadException
    extends IOException {
        private static final long serialVersionUID = -1315865533038108466L;
        private Collection<String> heads;

        public MultipleOccuranceOfHeadException(Collection<String> heads) {
            super("Multiple occurance of heads in csv: " + StringUtil.implode(heads, ", "));
            this.heads = heads;
        }

        public Collection<String> getHead() {
            return this.heads;
        }
    }
}

