/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.datatypes;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.ktde.util.StringUtil;

public class UnionFind<T> {
    private Hashtable<T, UnionTree<T>> values = new Hashtable();

    public T getRoot(T o1) {
        UnionTree<T> t1 = this.values.get(o1);
        if (t1 == null) {
            t1 = new UnionTree<T>(o1);
            this.values.put(o1, t1);
            return o1;
        }
        return (T)((UnionTree)t1.find()).object;
    }

    public Iterator<T> getIterator(T o1) {
        return new UnionIterator(o1);
    }

    public void union(T o1, T o2) {
        if (o1.equals(o2)) {
            UnionTree<T> t1 = this.values.get(o1);
            if (t1 == null) {
                t1 = new UnionTree<T>(o1);
                this.values.put(o1, t1);
            }
            return;
        }
        UnionTree<T> t1 = this.values.get(o1);
        UnionTree<T> t2 = this.values.get(o2);
        if (t1 == null && t2 == null) {
            t1 = new UnionTree<T>(o1);
            t2 = new UnionTree<T>(o2);
            t1.setParent(t2);
            this.values.put(o1, t1);
            this.values.put(o2, t2);
        } else if (t1 == null) {
            t1 = new UnionTree<T>(o1);
            t1.setParent(t2);
            this.values.put(o1, t1);
        } else if (t2 == null) {
            t2 = new UnionTree<T>(o2);
            t2.setParent(t1);
            this.values.put(o2, t2);
        } else {
            this.union(t1, t2);
        }
    }

    public boolean sameUnion(T o1, T o2) {
        if (o1.equals(o2)) {
            UnionTree<T> t1 = this.values.get(o1);
            if (t1 == null) {
                t1 = new UnionTree<T>(o1);
                this.values.put(o1, t1);
            }
            return true;
        }
        UnionTree<T> t1 = this.values.get(o1);
        UnionTree<T> t2 = this.values.get(o2);
        if (t1 == null && t2 == null) {
            t1 = new UnionTree<T>(o1);
            t2 = new UnionTree<T>(o2);
            this.values.put(o1, t1);
            this.values.put(o2, t2);
            return false;
        }
        if (t1 == null) {
            t1 = new UnionTree<T>(o1);
            this.values.put(o1, t1);
            return false;
        }
        if (t2 == null) {
            t2 = new UnionTree<T>(o2);
            this.values.put(o2, t2);
            return false;
        }
        return this.sameUnion(t1, t2);
    }

    protected void union(UnionTree<T> t, UnionTree<T> u) {
        if (this.sameUnion(t, u)) {
            return;
        }
        t = t.find();
        u = u.find();
        if (t.getSize() > u.getSize()) {
            u.setParent(t);
        } else {
            t.setParent(u);
        }
    }

    protected boolean sameUnion(UnionTree<T> t, UnionTree<T> u) {
        return t.find() == u.find();
    }

    public String toString() {
        Vector<String> names = new Vector<String>();
        Hashtable<String, Integer> ids = new Hashtable<String, Integer>();
        for (UnionTree<T> tree : this.values.values()) {
            names.add(((UnionTree)tree).object + "");
        }
        Collections.sort(names);
        Vector<String> strings = new Vector<String>();
        int num = 0;
        for (String string : names) {
            ids.put(string, num++);
            strings.add(null);
        }
        for (UnionTree unionTree : this.values.values()) {
            String s;
            UnionTree parent = unionTree.find();
            int i = (Integer)ids.get(parent.object.toString() + "");
            if (strings.get(i) == null) {
                s = parent.object.toString() + ": " + unionTree.object.toString();
                strings.set(i, s);
                continue;
            }
            s = (String)strings.get(i) + "," + unionTree.object.toString();
            strings.set(i, s);
        }
        Vector<String> notnull = new Vector<String>();
        for (String string : strings) {
            if (string == null) continue;
            notnull.add(string);
        }
        String string = StringUtil.implode(notnull, " / ");
        return string;
    }

    private class UnionTree<T2> {
        private UnionTree<T2> parent;
        private int size = 1;
        private T2 object;

        public UnionTree(T2 object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.object = object;
        }

        public void setParent(UnionTree<T2> u) {
            this.parent = u;
            u.size = Math.max(u.size, this.size + 1);
        }

        public int getSize() {
            return this.size;
        }

        public UnionTree<T2> find() {
            if (this.parent == null) {
                return this;
            }
            UnionTree<T2> find = this.parent.find();
            if (this.parent != find) {
                this.setParent(find);
            }
            return find;
        }
    }

    private class UnionIterator
    implements Iterator<T> {
        private Iterator<T> delIterator;
        private T current;
        private T sameAs;

        private UnionIterator(T sameAs) {
            this.sameAs = sameAs;
            this.delIterator = UnionFind.this.values.keySet().iterator();
            this.locateNext();
        }

        private void locateNext() {
            while (this.delIterator.hasNext()) {
                this.current = this.delIterator.next();
                if (!UnionFind.this.sameUnion(this.sameAs, this.current)) continue;
                return;
            }
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            Object current = this.current;
            this.locateNext();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

