/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.datatypes;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ktde.util.datatypes.ArrayValuesComparator;
import org.ktde.util.datatypes.Range;
import org.ktde.util.datatypes.Tupel;
import org.ktde.util.polygon.TreePartition;

public class ArrayHelper {
    public static String[] getSequenceFromString(String s, String[] values) {
        ArrayList<String> list = new ArrayList<String>();
        Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
        for (int i = 0; i < values.length; ++i) {
            String element = values[i];
            if (element == null) {
                throw new NullPointerException();
            }
            if (hash.containsKey(element)) {
                throw new IllegalArgumentException("values must be unique");
            }
            hash.put(element, i);
        }
        ArrayHelper.getSequenceFromString(s, values, hash, list);
        Collections.sort(list, new ArrayValuesComparator<String>(hash));
        ArrayHelper.uniq(list);
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    private static void getSequenceFromString(String s, String[] values, Hashtable<String, Integer> hash, ArrayList<String> list) {
        try {
            s = s.trim();
            if (s.length() == 0) {
                return;
            }
            String[] parts = s.split(",|/");
            if (parts.length == 1) {
                int start = 0;
                int end = hash.size() - 1;
                parts = s.split("-");
                if (parts.length == 2) {
                    parts[0] = parts[0].trim();
                    if (parts[0].length() > 0) {
                        start = hash.get(parts[0]);
                    }
                    parts[1] = parts[1].trim();
                    if (parts[1].length() > 0) {
                        end = hash.get(parts[1]);
                    }
                } else if (s.startsWith("-")) {
                    s = s.substring(1).trim();
                    end = hash.get(s);
                } else if (s.endsWith("-")) {
                    s = s.substring(0, s.length() - 1).trim();
                    start = hash.get(s);
                } else {
                    start = end = hash.get(s).intValue();
                }
                if (end == -1 || start == -1) {
                    throw new IllegalArgumentException("Input String doesn't match values");
                }
                if (start > end) {
                    throw new IllegalArgumentException("Range must be ordered");
                }
                for (int i = start; i <= end; ++i) {
                    list.add(values[i]);
                }
            } else {
                for (String part : parts) {
                    ArrayHelper.getSequenceFromString(part, values, hash, list);
                }
            }
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("Input String doesn't match values");
        }
    }

    public static int[] getSequenceFromString(String s, int min, int max) {
        String[] values = new String[max - min + 1];
        for (int i = min; i <= max; ++i) {
            values[i - min] = Integer.toString(i);
        }
        String[] resultStrings = ArrayHelper.getSequenceFromString(s, values);
        int[] result = new int[resultStrings.length];
        for (int i = 0; i < resultStrings.length; ++i) {
            result[i] = Integer.valueOf(resultStrings[i]);
        }
        return result;
    }

    public static int[] getSequenceFromString(String s, int max) {
        return ArrayHelper.getSequenceFromString(s, 0, max);
    }

    public static <T> void uniq(List<T> list) {
        ArrayHelper.uniq(list, false);
    }

    public static <T> void uniq(List<T> list, boolean strict) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        T last = list.get(0);
        for (int i = 1; i < size; ++i) {
            T cur = list.get(i);
            if (cur == last || !strict && cur.equals(last)) {
                list.remove(i);
                --i;
                --size;
                continue;
            }
            last = cur;
        }
    }

    public static <T> T[] changeSize(T[] src, int newSize) {
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), newSize);
        System.arraycopy(src, 0, dst, 0, Math.min(src.length, newSize));
        return dst;
    }

    public static byte[] changeSize(byte[] src, int newSize) {
        byte[] dst = new byte[newSize];
        System.arraycopy(src, 0, dst, 0, Math.min(src.length, newSize));
        return dst;
    }

    public static int[] changeSize(int[] src, int newSize) {
        int[] dst = new int[newSize];
        System.arraycopy(src, 0, dst, 0, Math.min(src.length, newSize));
        return dst;
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static boolean isEmpty(Collection<?> objects) {
        return objects == null || objects.size() == 0;
    }

    public static <T> Set<T> getRemainder(Set<? extends T> from, Set<? extends T> without) {
        HashSet<? extends T> remainder = new HashSet<T>();
        remainder.addAll(from);
        remainder.removeAll(without);
        return remainder;
    }

    public static <T> List<T> rotate(List<T> list, int rotateOffset) {
        int size = list.size();
        while (rotateOffset < 0) {
            rotateOffset = size + rotateOffset;
        }
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            result.add(list.get((i + rotateOffset) % size));
        }
        return result;
    }

    private static int getLeadBitPosition(int x) {
        String bitstring = Integer.toBinaryString(x);
        int result = 0;
        for (int i = 0; i < bitstring.length(); ++i) {
            result *= 4;
            if (bitstring.charAt(i) != '1') continue;
            ++result;
        }
        return result;
    }

    public static int getBitPosition(int x, int y) {
        int xlead;
        int result = xlead = ArrayHelper.getLeadBitPosition(x);
        if (y > 0) {
            int ylead = ArrayHelper.getLeadBitPosition(y) * 2;
            result += ylead;
        }
        return result;
    }

    private static int getValForBitPosition(int bit, boolean xory) {
        int off;
        String bitstring = Integer.toBinaryString(bit);
        int result = 0;
        for (int i = off = xory ? 1 - bitstring.length() % 2 : bitstring.length() % 2; i < bitstring.length(); i += 2) {
            result *= 2;
            if (bitstring.charAt(i) != '1') continue;
            ++result;
        }
        return result;
    }

    public static int getXForBitPosition(int bit) {
        return ArrayHelper.getValForBitPosition(bit, true);
    }

    public static int getYForBitPosition(int bit) {
        return ArrayHelper.getValForBitPosition(bit, false);
    }

    public static TreePartition getHierarchy(BitSet bitSet) {
        Tupel<Integer, TreePartition> tupel = ArrayHelper.getHierarchy(bitSet, 0, bitSet.size(), 5);
        return tupel == null ? null : tupel.getElement2();
    }

    private static Tupel<Integer, TreePartition> getHierarchy(BitSet bitSet, int offset, int length, int maxDepth) {
        if (maxDepth > 0 && length > 2) {
            int lenH = length / 2;
            Tupel<Integer, TreePartition> firstTupel = ArrayHelper.getHierarchy(bitSet, offset, lenH, maxDepth - 1);
            Tupel<Integer, TreePartition> secondTupel = ArrayHelper.getHierarchy(bitSet, offset + lenH, length - lenH, maxDepth - 1);
            if (firstTupel == null && secondTupel == null) {
                return null;
            }
            if (firstTupel != null && secondTupel != null) {
                int from;
                int to;
                TreePartition firstPartition = firstTupel.getElement2();
                int firstFrom = firstPartition.getRange().getFrom();
                TreePartition secondPartition = secondTupel.getElement2();
                int secondTo = secondPartition.getRange().getTo();
                int fill = firstTupel.getElement1() + secondTupel.getElement1();
                int ratio = 100 * fill / ((to = secondTo) + 1 - (from = firstFrom));
                TreePartition treePartition = ratio > 25 ? new TreePartition(new Range(firstFrom, secondTo)) : new TreePartition(firstPartition, secondPartition);
                return new Tupel<Integer, TreePartition>(fill, treePartition);
            }
            if (firstTupel != null) {
                return firstTupel;
            }
            return secondTupel;
        }
        boolean set = false;
        int rangeStart = 0;
        int rangeEnd = 0;
        for (int i = offset; i < offset + length; ++i) {
            if (!bitSet.get(i)) continue;
            if (!set) {
                rangeStart = i;
            }
            set = true;
            rangeEnd = i;
        }
        if (!set) {
            return null;
        }
        return new Tupel<Integer, TreePartition>(1, new TreePartition(new Range(rangeStart, rangeEnd)));
    }

    public static void hierarchicalBitsOn(BitSet bitset, int xMin, int xMax, int yMin, int yMax) {
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                bitset.set(ArrayHelper.getBitPosition(x, y));
            }
        }
    }

    public static boolean cyclicEquals(List<?> list1, List<?> list2) {
        return ArrayHelper.cyclicEquals(list1.toArray(), list2.toArray());
    }

    public static boolean cyclicEquals(Object[] array1, Object[] array2) {
        int len = array1.length;
        if (len != array2.length) {
            return false;
        }
        Object first = array1[0];
        LinkedList<Integer> potStarts = new LinkedList<Integer>();
        for (int i = 0; i < len; ++i) {
            Object second = array2[i];
            if ((first != null || second != null) && !first.equals(second)) continue;
            potStarts.add(i);
        }
        for (Integer integer : potStarts) {
            boolean ok = true;
            for (int i = 0; i < len; ++i) {
                first = array1[i];
                Object second = array2[(i + integer) % len];
                if (first == null && second == null || first.equals(second)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return true;
        }
        return false;
    }
}

