/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.ktde.util.cache.ChangeSet;

public class ChangeSetUndoEditable
implements UndoableEdit {
    private final List<ChangeSet> changes;
    private List<ChangeSet> changesReverse;
    private final String name;

    public ChangeSetUndoEditable(String name, List<ChangeSet> changes) {
        this.name = name;
        this.changes = changes;
    }

    public List<ChangeSet> getChanges() {
        return this.changes;
    }

    @Override
    public boolean addEdit(UndoableEdit arg0) {
        return false;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void die() {
    }

    @Override
    public String getPresentationName() {
        return this.name;
    }

    @Override
    public String getRedoPresentationName() {
        return this.name;
    }

    @Override
    public String getUndoPresentationName() {
        return this.name;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public void redo() throws CannotRedoException {
        for (ChangeSet changeSet : this.changes) {
            changeSet.redo();
        }
    }

    @Override
    public boolean replaceEdit(UndoableEdit arg0) {
        return false;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.changesReverse == null) {
            this.changesReverse = new ArrayList<ChangeSet>(this.changes);
            Collections.reverse(this.changesReverse);
        }
        for (ChangeSet changeSet : this.changesReverse) {
            changeSet.undo();
        }
    }
}

