/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.cache;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.util.ContextLocal;

public class ChangeSet {
    private static ThreadLocal<ChangeSet> currentChangeSet = new ThreadLocal();
    private static ThreadLocal<Boolean> applyInProgress = new ThreadLocal();
    public static ContextLocal<List<ChangeSet>> currentChangeTransaction = new ContextLocal();
    private Map<String, Object> oldValues;
    private Map<String, Object> newValues;
    private Object object;
    private boolean delete = false;

    private ChangeSet(Object object, String prop) {
        this.object = object;
        this.oldValues = prop == null ? null : ChangeSet.readValues(object, Collections.singleton(prop));
    }

    public boolean isEmpty() {
        return this.oldValues != null && this.newValues != null && this.oldValues.isEmpty();
    }

    public boolean isDelete() {
        return this.delete;
    }

    public boolean isCreate() {
        return this.oldValues == null && !this.isDelete();
    }

    public Object getObject() {
        return this.object;
    }

    private void setDelete(boolean delete) {
        this.delete = delete;
    }

    private void saveNewValues() {
        if (this.oldValues != null) {
            Set<String> keys = this.oldValues.keySet();
            this.newValues = ChangeSet.readValues(this.object, keys);
            for (String key : keys) {
                Object o2;
                Object o1 = this.oldValues.get(key);
                if (o1 != (o2 = this.newValues.get(key))) continue;
                this.oldValues.remove(key);
                this.newValues.remove(key);
            }
        } else {
            this.newValues = new HashMap<String, Object>();
        }
    }

    private static Map<String, Object> readValues(Object object, Set<String> keys) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        Class<?> class1 = object.getClass();
        for (String name : keys) {
            Object value;
            Method method;
            String getter = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            try {
                method = class1.getMethod(getter, new Class[0]);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                getter = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                try {
                    method = class1.getMethod(getter, new Class[0]);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    continue;
                }
            }
            try {
                value = method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            values.put(name, value);
        }
        return values;
    }

    public String toString() {
        if (this.oldValues == null) {
            return this.object.toString() + " created";
        }
        if (this.newValues == null) {
            return this.object.toString() + " deleted";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.object.toString() + " changed\n");
        for (String key : this.newValues.keySet()) {
            builder.append("\t" + key + ": " + this.oldValues.get(key) + "->" + this.newValues.get(key) + "\n");
        }
        return builder.toString();
    }

    public static void startChange(Object o, String prop) {
        Boolean applyInProgress = ChangeSet.applyInProgress.get();
        if (applyInProgress == null) {
            currentChangeSet.set(new ChangeSet(o, prop));
        }
    }

    public static void delete(Object o) {
        ChangeSet.startChange(o, null);
        ChangeSet.finishChange(true);
    }

    public static void finishChange() {
        ChangeSet.finishChange(false);
    }

    public static void finishChange(boolean deleted) {
        Boolean applyInProgress = ChangeSet.applyInProgress.get();
        if (applyInProgress == null) {
            ChangeSet current = currentChangeSet.get();
            if (!deleted) {
                current.saveNewValues();
            }
            if (deleted) {
                current.setDelete(true);
                List<ChangeSet> currentChanges = currentChangeTransaction.get();
                if (currentChanges == null) {
                    throw new IllegalStateException("cannot finish a changeset when no current transaction exists. Try joining one");
                }
                currentChanges.add(current);
            } else if (!current.isEmpty()) {
                List<ChangeSet> currentChanges = currentChangeTransaction.get();
                if (currentChanges == null) {
                    throw new IllegalStateException("cannot finish a changeset when no current transaction exists. Try joining one");
                }
                if (currentChanges.isEmpty()) {
                    currentChanges.add(current);
                } else {
                    int lastIndex = currentChanges.size() - 1;
                    ChangeSet last = currentChanges.get(lastIndex);
                    if (current.object == last.object) {
                        if (current.newValues == null) {
                            if (last.oldValues == null) {
                                currentChanges.remove(lastIndex);
                            } else {
                                last.newValues = null;
                            }
                        } else if (last.oldValues == null) {
                            currentChanges.add(current);
                        } else {
                            last.newValues.putAll(current.newValues);
                            if (last.oldValues != null) {
                                for (String prop : current.oldValues.keySet()) {
                                    if (last.oldValues.containsKey(prop)) continue;
                                    last.oldValues.put(prop, current.oldValues.get(prop));
                                }
                            }
                        }
                    } else {
                        currentChanges.add(current);
                    }
                }
            }
            currentChangeSet.remove();
        }
    }

    public void redo() {
        if (this.isDelete()) {
            this.executeDelete(this.object);
        }
        if (this.oldValues != null && this.newValues != null) {
            ChangeSet.applyValues(this.object, this.newValues);
        }
    }

    protected void executeDelete(Object object) {
        this.executeMethod(object, "delete");
    }

    private void executeMethod(Object object, String methodName) {
        applyInProgress.set(true);
        Class<?> class1 = object.getClass();
        Method[] methods = class1.getMethods();
        Method method = null;
        for (Method method2 : methods) {
            if (!method2.getName().equals(methodName) || method2.getTypeParameters().length != 0) continue;
            method = method2;
            break;
        }
        try {
            method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void executeUndelete(Object object) {
        this.executeMethod(object, "undelete");
    }

    public void undo() {
        if (this.isDelete()) {
            this.executeUndelete(this.object);
        }
        if (this.isDelete() || this.oldValues != null && this.newValues != null) {
            ChangeSet.applyValues(this.object, this.oldValues);
        }
    }

    private static void applyValues(Object object, Map<String, Object> values) {
        applyInProgress.set(true);
        Class<?> class1 = object.getClass();
        if (values != null) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                Method[] methods;
                String name = entry.getKey();
                String setter = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
                Method method = null;
                for (Method method2 : methods = class1.getMethods()) {
                    if (!method2.getName().equals(setter)) continue;
                    method = method2;
                    break;
                }
                try {
                    method.invoke(object, entry.getValue());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        applyInProgress.remove();
    }
}

