/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class DynamicAttributedProperties
extends Properties {
    private static final long serialVersionUID = 2748939878526977770L;
    private Set<String> dynamicProperties = new HashSet<String>();

    public DynamicAttributedProperties() {
    }

    public DynamicAttributedProperties(Properties parent) {
        super(parent);
    }

    public boolean isPropertyDynamic(String property) {
        return this.dynamicProperties.contains(property);
    }

    public Set<String> getDynamicPropertyName() {
        return Collections.unmodifiableSet(this.dynamicProperties);
    }

    public Properties getDynamicProperties() {
        Properties properties = new Properties();
        for (String name : this.getDynamicPropertyName()) {
            properties.setProperty(name, this.getProperty(name));
        }
        return properties;
    }

    public void setDynamicProperty(String name, String value) {
        this.setProperty(name, value);
        this.markPropertyDynamic(name);
    }

    public void markPropertyDynamic(String property) {
        this.dynamicProperties.add(property);
    }

    public void unmarkPropertyDynamic(String property) {
        this.dynamicProperties.remove(property);
    }

    public void loadDynamic(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String next = en.nextElement().toString();
            this.setProperty(next, properties.getProperty(next));
            this.markPropertyDynamic(next);
        }
    }
}

