/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.algorithm;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class ObjectSemaphore<T> {
    private final ConcurrentHashMap<T, Semaphore> semaphoreMap = new ConcurrentHashMap();

    public void acquire(T object) throws InterruptedException {
        Semaphore s = this.getSemaphore(object);
        s.acquire();
    }

    protected Semaphore getSemaphore(T object) {
        Semaphore s = this.semaphoreMap.get(object);
        if (s == null) {
            s = new Semaphore(1);
            if ((s = this.semaphoreMap.putIfAbsent(object, s)) == null) {
                s = this.semaphoreMap.get(object);
            }
        }
        return s;
    }

    public void release(T object) {
        Semaphore s = this.semaphoreMap.get(object);
        if (s != null) {
            s.release();
        }
    }

    public void remove(T object) {
        this.semaphoreMap.remove(object);
    }

    public boolean tryAcquire(T object) {
        Semaphore s = this.getSemaphore(object);
        return s.tryAcquire();
    }
}

