/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util.algorithm;

import javax.swing.event.EventListenerList;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.algorithm.AlgorithmStepEvent;
import org.ktde.util.algorithm.AlgorithmStepListener;
import org.ktde.util.algorithm.InputDataValidationException;

public abstract class Algorithm
implements Runnable {
    private EventListenerList listeners;
    private int stepsLeft;
    private int stepsTotal;
    private long startTime;
    private AlgorithmException algorithmException;

    public void addAlgorithmStepListener(AlgorithmStepListener listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
            this.listeners.add(AlgorithmStepListener.class, listener);
        }
    }

    public void removeAlgorithmStepListener(AlgorithmStepListener listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
            this.listeners.remove(AlgorithmStepListener.class, listener);
        }
    }

    public void start(boolean asThread) {
        if (asThread) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    @Override
    public final void run() {
        this.stepsLeft = this.stepsTotal = this.preCalcSteps();
        this.startTime = System.currentTimeMillis();
        try {
            this.validateInput();
            this.perform();
        }
        catch (AlgorithmException e) {
            this.algorithmException = e;
        }
    }

    protected abstract void perform() throws AlgorithmException;

    public abstract int preCalcSteps();

    protected void finishStep() {
        this.finishStep(1, this.stepsTotal);
    }

    protected void finishStep(int stepsTotal) {
        this.finishStep(1, stepsTotal);
    }

    protected void finishSteps(int steps) {
        this.finishStep(steps, this.stepsTotal);
    }

    protected void finishStep(int steps, int stepsTotal) {
        this.stepsLeft -= steps;
        if (stepsTotal > 0) {
            this.stepsTotal = stepsTotal;
        }
        if (this.stepsLeft < 0) {
            this.stepsTotal -= this.stepsLeft;
            this.stepsLeft = 0;
        }
        if (this.listeners != null) {
            long time = System.currentTimeMillis() - this.startTime;
            time = (long)((double)time * ((double)this.stepsLeft / (double)(this.stepsTotal - this.stepsLeft)));
            AlgorithmStepEvent event = new AlgorithmStepEvent(this, this.stepsLeft, this.stepsTotal, time);
            this.fireEvent(event);
        }
    }

    protected void finishTotal() {
        this.finishSteps(this.stepsLeft);
    }

    protected void fireEvent(AlgorithmStepEvent event) {
        if (this.listeners != null) {
            for (AlgorithmStepListener listener : (AlgorithmStepListener[])this.listeners.getListeners(AlgorithmStepListener.class)) {
                listener.algorithmStepPerformed(event);
            }
        }
    }

    public boolean wasSuccessfull() {
        return this.algorithmException == null;
    }

    public boolean wasInputDataValidationError() {
        return this.algorithmException instanceof InputDataValidationException;
    }

    public AlgorithmException getAlgorithmException() {
        return this.algorithmException;
    }

    protected int getStepsLeft() {
        return this.stepsLeft;
    }

    protected abstract void validateInput() throws InputDataValidationException;
}

