/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util;

public class TimeStatistic {
    private long startTime;
    private volatile long currentTime;
    private volatile long endTime;
    private long todoTasks;
    private volatile long doneTasks;
    private double todoSize;
    private volatile double doneSize;

    public TimeStatistic(long todoTasks) {
        this(todoTasks, todoTasks);
    }

    public TimeStatistic(long todoTasks, long todoSize) {
        this.todoTasks = todoTasks;
        this.todoSize = todoSize;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.updateStats();
    }

    public void updateStats() {
        this.endTime = (long)((double)this.startTime + (double)(this.currentTime - this.startTime) * (this.todoSize - this.doneSize) / this.doneSize);
    }

    public void incDoneTasks() {
        this.incDoneTasks(1);
    }

    public void incDoneTasks(int count) {
        this.incDoneTasks(count, count);
    }

    public void incDoneTasks(int count, long sizediff) {
        this.doneTasks += (long)count;
        this.doneSize += (double)sizediff;
        this.currentTime = System.currentTimeMillis();
        this.updateStats();
    }

    public String toString() {
        return this.doneTasks + "/" + this.todoTasks + " in " + (this.currentTime - this.startTime) + "ms Remaining: " + (this.todoTasks - this.doneTasks) + " est. " + (this.endTime - this.currentTime) + "ms " + (double)((int)(1000.0 * this.doneSize / this.doneSize)) / 10.0 + "%";
    }
}

