/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util;

import java.io.IOException;
import java.io.Writer;

public class ForkingWriter
extends Writer {
    private Writer[] writers;

    public ForkingWriter(Writer ... writers) {
        this.writers = writers;
    }

    @Override
    public void close() throws IOException {
        for (Writer writer : this.writers) {
            writer.close();
        }
    }

    @Override
    public void flush() throws IOException {
        for (Writer writer : this.writers) {
            writer.flush();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (Writer writer : this.writers) {
            writer.write(cbuf, off, len);
        }
    }

    public synchronized void addWriter(Writer writer) {
        int length = this.writers.length;
        Writer[] newWriters = new Writer[length + 1];
        System.arraycopy(this.writers, 0, newWriters, 0, length);
        newWriters[length] = writer;
        this.writers = newWriters;
    }
}

